/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.enhance.registrar.factory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.nutz.dao.Dao;
import org.nutz.dao.enhance.audit.AuditHandler;
import org.nutz.dao.enhance.config.DaoProperties;
import org.nutz.dao.enhance.enhance.EnhanceNutDao;
import org.nutz.dao.enhance.factory.EnhanceCoreFactory;
import org.nutz.dao.enhance.method.holder.AutoCreateTableHolder;
import org.nutz.dao.enhance.util.FieldCalcUtil;
import org.nutz.ioc.Ioc;

public class DefaualtNutEnhanceCoreFactory
implements EnhanceCoreFactory {
    private final Map<String, Dao> daoCache = new HashMap<String, Dao>();
    private final Ioc ioc;
    private final DaoProperties daoProperties;

    public DefaualtNutEnhanceCoreFactory(Ioc ioc, DaoProperties daoProperties) {
        this.ioc = ioc;
        this.daoProperties = daoProperties;
        FieldCalcUtil.setEnhanceCoreFactory((EnhanceCoreFactory)this);
    }

    public Dao getDao() {
        return this.getDao("dataSource");
    }

    public Dao getDao(String dataSource) {
        return this.daoCache.get(dataSource);
    }

    public AuditHandler getAuditHandler() {
        return (AuditHandler)this.ioc.getByType(AuditHandler.class);
    }

    public Object getBean(String beanName) {
        Class type = this.ioc.getType(beanName);
        return this.ioc.get(type, beanName);
    }

    public void init() {
        DataSource dataSource = (DataSource)this.ioc.get(DataSource.class);
        this.daoCache.put("dataSource", (Dao)new EnhanceNutDao(dataSource));
        String[] names = this.ioc.getNamesByType(DataSource.class);
        Arrays.stream(names).filter(dsName -> !this.daoCache.containsKey(dsName)).forEach(dsName -> this.daoCache.put((String)dsName, (Dao)new EnhanceNutDao((DataSource)this.ioc.get(DataSource.class))));
        AutoCreateTableHolder.autoGenerateDdl((EnhanceCoreFactory)this, (DaoProperties)this.daoProperties);
    }
}

