/*
 * Decompiled with CFR 0.152.
 */
package org.nosceon.datolite.db;

import com.jolbox.bonecp.BoneCPDataSource;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.nosceon.datolite.Context;
import org.nosceon.datolite.db.AutoCleanConnectionHandler;
import org.nosceon.datolite.db.DbPlugin;
import org.nosceon.datolite.db.exception.UnableToGetConnectionException;
import org.nosceon.datolite.db.exception.UncategorizedDatabaseException;
import org.nosceon.datolite.util.Memoizer;

final class DbPluginImpl
implements DbPlugin {
    public static final String DEFAULT_CONFIG_PATH = "db";
    private final Memoizer<String, DataSource> cache = new Memoizer(this::createDataSource);
    private final Context context;

    DbPluginImpl(Context context) {
        this.context = context;
    }

    @Override
    public DataSource dataSource() {
        return this.dataSource(DEFAULT_CONFIG_PATH);
    }

    @Override
    public DataSource dataSource(String configPath) {
        return (DataSource)this.cache.get((Object)configPath);
    }

    @Override
    public Connection connection() {
        return this.connection(true);
    }

    @Override
    public Connection connection(boolean autoCommit) {
        return this.connection(DEFAULT_CONFIG_PATH, autoCommit);
    }

    @Override
    public Connection connection(String configPath) {
        return this.connection(configPath, true);
    }

    @Override
    public Connection connection(String configPath, boolean autoCommit) {
        try {
            Connection connection = this.dataSource(configPath).getConnection();
            connection.setAutoCommit(autoCommit);
            return connection;
        }
        catch (SQLException e) {
            throw new UnableToGetConnectionException(e);
        }
    }

    @Override
    public <A> A withConnection(DbPlugin.ConnectionCallback<A> block) {
        return this.withConnection(DEFAULT_CONFIG_PATH, block);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <A> A withConnection(String configPath, DbPlugin.ConnectionCallback<A> block) {
        try (Connection con = this.autoClean(this.connection(configPath));){
            A a = block.withConnection(con);
            return a;
        }
        catch (SQLException e) {
            throw new UncategorizedDatabaseException(e);
        }
    }

    @Override
    public <A> A withTransaction(DbPlugin.ConnectionCallback<A> block) {
        return this.withTransaction(DEFAULT_CONFIG_PATH, block);
    }

    @Override
    public <A> A withTransaction(String configPath, final DbPlugin.ConnectionCallback<A> block) {
        return this.withConnection(configPath, new DbPlugin.ConnectionCallback<A>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public A withConnection(Connection connection) throws SQLException {
                boolean commit = false;
                try {
                    connection.setAutoCommit(false);
                    Object a = block.withConnection(connection);
                    commit = true;
                    Object t = a;
                    return t;
                }
                finally {
                    if (commit) {
                        connection.commit();
                    } else {
                        connection.rollback();
                    }
                }
            }
        });
    }

    private Connection autoClean(Connection connection) {
        return (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new AutoCleanConnectionHandler(connection));
    }

    private DataSource createDataSource(String path) {
        Config conf = this.lookupConfig(path);
        BoneCPDataSource dataSource = new BoneCPDataSource();
        dataSource.setDriverClass(conf.getString("driver"));
        dataSource.setJdbcUrl(conf.getString("url"));
        dataSource.setUsername(conf.getString("user"));
        dataSource.setPassword(conf.getString("password"));
        dataSource.setPartitionCount(conf.getInt("partition-count"));
        dataSource.setMaxConnectionsPerPartition(conf.getInt("max-connections-per-partition"));
        dataSource.setMinConnectionsPerPartition(conf.getInt("min-connections-per-partition"));
        dataSource.setAcquireIncrement(conf.getInt("acquire-increment"));
        dataSource.setAcquireRetryAttempts(conf.getInt("acquire-retry-attempts"));
        dataSource.setAcquireRetryDelayInMs(conf.getLong("acquire-retry-delay"));
        dataSource.setConnectionTimeoutInMs(conf.getLong("connection-timeout"));
        dataSource.setIdleMaxAge(conf.getDuration("idle-max-age", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        dataSource.setMaxConnectionAge(conf.getDuration("max-connection-age", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        dataSource.setDisableJMX(conf.getBoolean("disable-jmx"));
        dataSource.setStatisticsEnabled(conf.getBoolean("statistics-enabled"));
        dataSource.setIdleConnectionTestPeriod(conf.getDuration("idle-connection-test-period", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        dataSource.setDisableConnectionTracking(conf.getBoolean("disable-connection-tracking"));
        this.context.onShutdown(() -> ((BoneCPDataSource)dataSource).close());
        return dataSource;
    }

    private Config lookupConfig(String path) {
        Config config = this.context.config();
        Config defaults = config.getConfig("datolite.defaults.bonecp");
        return config.hasPath(path) ? config.getConfig(path).withFallback((ConfigMergeable)defaults) : defaults;
    }
}

