/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.nosceon.datolite.db;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;

/**
 * @author Johan Siebens
 */
public interface DbPlugin {

    DataSource dataSource();

    DataSource dataSource(String configPath);

    Connection connection();

    Connection connection(boolean autoCommit);

    Connection connection(String configPath);

    Connection connection(String configPath, boolean autoCommit);

    <A> A withConnection(ConnectionCallback<A> block);

    <A> A withConnection(String configPath, ConnectionCallback<A> block);

    <A> A withTransaction(ConnectionCallback<A> block);

    <A> A withTransaction(String configPath, ConnectionCallback<A> block);

    interface ConnectionCallback<T> {

        T withConnection(Connection connection) throws SQLException;

    }

}
