/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;

public class AscReaderDriver {
    private static final int BATCH_MAX_SIZE = 100;
    private static final int BUFFER_SIZE = 16384;
    private boolean as3DPoint = true;
    private Envelope extractEnvelope = null;
    private int downScale = 1;
    private String lastWord = "";
    private int nrows;
    private int ncols;
    private double cellSize;
    private double yValue;
    private double xValue;
    private boolean readFirst;
    private double noData;
    private int zType = 2;
    private boolean deleteTable = false;
    private String encoding = "UTF-8";
    private boolean importNodata = false;

    public boolean isAs3DPoint() {
        return this.as3DPoint;
    }

    public void setAs3DPoint(boolean as3DPoint) {
        this.as3DPoint = as3DPoint;
    }

    public Envelope getExtractEnvelope() {
        return this.extractEnvelope;
    }

    public void setExtractEnvelope(Envelope extractEnvelope) {
        this.extractEnvelope = extractEnvelope;
    }

    public int getDownScale() {
        return this.downScale;
    }

    public void setDownScale(int downScale) {
        this.downScale = downScale;
    }

    private void readHeader(Scanner scanner) throws IOException {
        this.lastWord = scanner.next();
        if (!this.lastWord.equalsIgnoreCase("NCOLS")) {
            throw new IOException("Unexpected word " + this.lastWord);
        }
        this.lastWord = scanner.next();
        this.ncols = Integer.parseInt(this.lastWord);
        if (this.ncols <= 0) {
            throw new IOException("NCOLS <= 0");
        }
        this.lastWord = scanner.next();
        if (!this.lastWord.equalsIgnoreCase("NROWS")) {
            throw new IOException("Unexpected word " + this.lastWord);
        }
        this.lastWord = scanner.next();
        this.nrows = Integer.parseInt(this.lastWord);
        if (this.nrows <= 0) {
            throw new IOException("NROWS <= 0");
        }
        this.lastWord = scanner.next();
        if (!this.lastWord.equalsIgnoreCase("XLLCENTER") && !this.lastWord.equalsIgnoreCase("XLLCORNER")) {
            throw new IOException("Unexpected word " + this.lastWord);
        }
        boolean isXCenter = this.lastWord.equalsIgnoreCase("XLLCENTER");
        this.lastWord = scanner.next();
        this.xValue = Double.parseDouble(this.lastWord);
        this.lastWord = scanner.next();
        if (!this.lastWord.equalsIgnoreCase("YLLCENTER") && !this.lastWord.equalsIgnoreCase("YLLCORNER")) {
            throw new IOException("Unexpected word " + this.lastWord);
        }
        boolean isYCenter = this.lastWord.equalsIgnoreCase("YLLCENTER");
        this.lastWord = scanner.next();
        this.yValue = Double.parseDouble(this.lastWord);
        this.lastWord = scanner.next();
        if (!this.lastWord.equalsIgnoreCase("CELLSIZE")) {
            throw new IOException("Unexpected word " + this.lastWord);
        }
        this.lastWord = scanner.next();
        this.cellSize = Double.parseDouble(this.lastWord);
        if (isXCenter) {
            this.xValue -= this.cellSize / 2.0;
        }
        this.yValue = isYCenter ? this.yValue + this.cellSize * (double)this.nrows - this.cellSize / 2.0 : (this.yValue += this.cellSize * (double)this.nrows);
        this.lastWord = scanner.next();
        this.readFirst = false;
        this.noData = -9999.0;
        if (this.lastWord.equalsIgnoreCase("NODATA_VALUE")) {
            this.readFirst = true;
            this.lastWord = scanner.next();
            this.noData = Double.parseDouble(this.lastWord);
        }
    }

    public String[] read(Connection connection, File fileName, ProgressVisitor progress, String tableReference, int srid) throws SQLException, IOException {
        if (fileName != null && fileName.getName().toLowerCase().endsWith(".asc")) {
            if (!fileName.exists()) {
                throw new SQLException("The file " + tableReference + " doesn't exist ");
            }
            DBTypes dbType = DBUtils.getDBType((Connection)connection);
            TableLocation requestedTable = TableLocation.parse((String)tableReference, (DBTypes)dbType);
            String outputTableName = requestedTable.toString();
            if (this.deleteTable) {
                Statement stmt = connection.createStatement();
                stmt.execute("DROP TABLE IF EXISTS " + outputTableName);
                stmt.close();
            }
            try (FileInputStream inputStream = new FileInputStream(fileName);){
                outputTableName = this.readAsc(connection, inputStream, progress, outputTableName, srid);
            }
            return new String[]{outputTableName};
        }
        if (fileName != null && fileName.getName().toLowerCase().endsWith(".gz")) {
            if (!fileName.exists()) {
                throw new SQLException("The file " + tableReference + " doesn't exist ");
            }
            DBTypes dbType = DBUtils.getDBType((Connection)connection);
            TableLocation requestedTable = TableLocation.parse((String)tableReference, (DBTypes)dbType);
            String outputTableName = requestedTable.toString();
            if (this.deleteTable) {
                Statement stmt = connection.createStatement();
                stmt.execute("DROP TABLE IF EXISTS " + outputTableName);
                stmt.close();
            }
            FileInputStream fis = new FileInputStream(fileName);
            outputTableName = this.readAsc(connection, new GZIPInputStream(fis), progress, outputTableName, srid);
            return new String[]{outputTableName};
        }
        throw new SQLException("The asc read driver supports only asc or gz extensions");
    }

    private String readAsc(Connection connection, InputStream inputStream, ProgressVisitor progress, String outputTable, int srid) throws UnsupportedEncodingException, SQLException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream, 16384), this.encoding));
        try {
            Scanner scanner = new Scanner(reader);
            this.readHeader(scanner);
            connection.setAutoCommit(false);
            Statement st = connection.createStatement();
            int index = 0;
            if (!JDBCUtilities.tableExists((Connection)connection, (String)outputTable)) {
                if (this.as3DPoint) {
                    if (this.zType == 1) {
                        st.execute("CREATE TABLE " + outputTable + "(PK INT PRIMARY KEY, THE_GEOM GEOMETRY(POINTZ, " + srid + "), Z integer)");
                        connection.commit();
                    } else {
                        st.execute("CREATE TABLE " + outputTable + "(PK INT PRIMARY KEY, THE_GEOM GEOMETRY(POINTZ, " + srid + "), Z double precision)");
                        connection.commit();
                    }
                } else if (this.zType == 1) {
                    st.execute("CREATE TABLE " + outputTable + "(PK INT PRIMARY KEY, THE_GEOM GEOMETRY(POLYGONZ, " + srid + "),Z integer)");
                    connection.commit();
                } else {
                    st.execute("CREATE TABLE " + outputTable + "(PK INT PRIMARY KEY, THE_GEOM GEOMETRY(POLYGONZ, " + srid + "),Z double precision)");
                    connection.commit();
                }
            } else {
                try (ResultSet rs = st.executeQuery("SELECT MAX(PK) FROM " + outputTable);){
                    if (rs.next()) {
                        index = rs.getInt(1) + 1;
                    }
                }
            }
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + outputTable + "(PK, the_geom, Z) VALUES (?, ?, ?)");
            GeometryFactory factory = new GeometryFactory(new PrecisionModel(), srid);
            int batchSize = 0;
            int firstRow = 0;
            int firstCol = 0;
            int lastRow = this.nrows;
            int lastCol = this.ncols;
            if (this.extractEnvelope != null) {
                firstCol = (int)Math.floor((this.extractEnvelope.getMinX() - this.xValue) / this.cellSize);
                lastCol = (int)Math.ceil((this.extractEnvelope.getMaxX() - this.xValue) / this.cellSize);
                firstRow = this.nrows - (int)Math.ceil((this.extractEnvelope.getMaxY() - (this.yValue - this.cellSize * (double)this.nrows)) / this.cellSize);
                lastRow = this.nrows - (int)Math.ceil((this.extractEnvelope.getMinY() - (this.yValue - this.cellSize * (double)this.nrows)) / this.cellSize);
            }
            EmptyProgressVisitor cellProgress = new EmptyProgressVisitor();
            if (progress != null) {
                cellProgress = progress.subProcess(lastRow);
            }
            for (int i = 0; i < this.nrows; ++i) {
                for (int j = 0; j < this.ncols; ++j) {
                    Point cell;
                    if (this.readFirst) {
                        this.lastWord = scanner.next();
                    } else {
                        this.readFirst = true;
                    }
                    if (this.downScale != 1 && (i % this.downScale != 0 || j % this.downScale != 0) || this.extractEnvelope != null && (i < firstRow || i > lastRow || j < firstCol || j > lastCol)) continue;
                    double z = Double.parseDouble(this.lastWord);
                    double x = this.xValue + (double)j * this.cellSize;
                    double y = this.yValue - (double)i * this.cellSize;
                    if (this.as3DPoint) {
                        preparedStatement.setObject(1, index++);
                        cell = factory.createPoint(new Coordinate(x + this.cellSize / 2.0, y - this.cellSize / 2.0, z));
                        cell.setSRID(srid);
                        if (Math.abs(this.noData - z) != 0.0) {
                            preparedStatement.setObject(2, cell);
                            preparedStatement.setObject(3, z);
                            preparedStatement.addBatch();
                            ++batchSize;
                        } else if (this.importNodata) {
                            preparedStatement.setObject(2, cell);
                            preparedStatement.setObject(3, this.noData);
                            preparedStatement.addBatch();
                            ++batchSize;
                        }
                    } else {
                        preparedStatement.setObject(1, index++);
                        cell = factory.createPolygon(new Coordinate[]{new Coordinate(x, y, z), new Coordinate(x, y - this.cellSize * (double)this.downScale, z), new Coordinate(x + this.cellSize * (double)this.downScale, y - this.cellSize * (double)this.downScale, z), new Coordinate(x + this.cellSize * (double)this.downScale, y, z), new Coordinate(x, y, z)});
                        cell.setSRID(srid);
                        if (Math.abs(this.noData - z) != 0.0) {
                            preparedStatement.setObject(2, cell);
                            preparedStatement.setObject(3, z);
                            preparedStatement.addBatch();
                            ++batchSize;
                        } else if (this.importNodata) {
                            preparedStatement.setObject(2, cell);
                            preparedStatement.setObject(3, this.noData);
                            preparedStatement.addBatch();
                            ++batchSize;
                        }
                    }
                    if (batchSize < 100) continue;
                    preparedStatement.executeBatch();
                    connection.commit();
                    preparedStatement.clearBatch();
                    batchSize = 0;
                }
                cellProgress.endStep();
                if (i > lastRow) break;
            }
            if (batchSize > 0) {
                preparedStatement.executeBatch();
                connection.commit();
            }
            connection.setAutoCommit(true);
            return outputTable;
        }
        catch (IOException | NumberFormatException | SQLException | NoSuchElementException ex) {
            throw new SQLException("Unexpected word " + this.lastWord, ex);
        }
    }

    public void setZType(int zType) {
        this.zType = zType;
    }

    public void setDeleteTable(boolean deleteTable) {
        this.deleteTable = deleteTable;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setImportNodata(boolean importNodata) {
        this.importNodata = importNodata;
    }
}

