/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.SpatialResultSet;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.io.WKTWriter;
import org.noise_planet.noisemodelling.jdbc.GridMapMaker;
import org.noise_planet.noisemodelling.jdbc.NoiseMapDatabaseParameters;
import org.noise_planet.noisemodelling.jdbc.input.DefaultTableLoader;
import org.noise_planet.noisemodelling.jdbc.input.SceneDatabaseInputSettings;
import org.noise_planet.noisemodelling.jdbc.input.SceneWithEmission;
import org.noise_planet.noisemodelling.jdbc.output.DefaultCutPlaneProcessing;
import org.noise_planet.noisemodelling.jdbc.utils.CellIndex;
import org.noise_planet.noisemodelling.pathfinder.CutPlaneVisitorFactory;
import org.noise_planet.noisemodelling.pathfinder.PathFinder;
import org.noise_planet.noisemodelling.pathfinder.path.Scene;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.ProfilerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoiseMapByReceiverMaker
extends GridMapMaker {
    private final String receiverTableName;
    private TableLoader tableLoader = new DefaultTableLoader();
    public AtomicBoolean exitWhenDone = new AtomicBoolean(false);
    public AtomicBoolean aborted = new AtomicBoolean(false);
    private final NoiseMapDatabaseParameters noiseMapDatabaseParameters = new NoiseMapDatabaseParameters();
    private IComputeRaysOutFactory computeRaysOutFactory = new DefaultCutPlaneProcessing(this.noiseMapDatabaseParameters, this.exitWhenDone, this.aborted);
    private Logger logger = LoggerFactory.getLogger(NoiseMapByReceiverMaker.class);
    private int threadCount = 0;
    private ProfilerThread profilerThread;
    SceneDatabaseInputSettings sceneDatabaseInputSettings = new SceneDatabaseInputSettings();

    public NoiseMapByReceiverMaker(String buildingsTableName, String sourcesTableName, String receiverTableName) {
        super(buildingsTableName, sourcesTableName);
        this.receiverTableName = receiverTableName;
    }

    public NoiseMapDatabaseParameters getNoiseMapDatabaseParameters() {
        return this.noiseMapDatabaseParameters;
    }

    public String getSourcesEmissionTableName() {
        return this.sceneDatabaseInputSettings.getSourcesEmissionTableName();
    }

    public SceneDatabaseInputSettings.INPUT_MODE getInputMode() {
        return this.sceneDatabaseInputSettings.getInputMode();
    }

    public void setInputMode(SceneDatabaseInputSettings.INPUT_MODE inputMode) {
        this.sceneDatabaseInputSettings.setInputMode(inputMode);
    }

    public String getSourceEmissionPrimaryKeyField() {
        return this.sceneDatabaseInputSettings.getSourceEmissionPrimaryKeyField();
    }

    public void setSourceEmissionPrimaryKeyField(String sourceEmissionPrimaryKeyField) {
        this.sceneDatabaseInputSettings.setSourceEmissionPrimaryKeyField(sourceEmissionPrimaryKeyField);
    }

    public String getFrequencyFieldPrepend() {
        return this.sceneDatabaseInputSettings.getFrequencyFieldPrepend();
    }

    public void setFrequencyFieldPrepend(String frequencyFieldPrepend) {
        this.sceneDatabaseInputSettings.setFrequencyFieldPrepend(frequencyFieldPrepend);
    }

    public SceneDatabaseInputSettings getSceneInputSettings() {
        return this.sceneDatabaseInputSettings;
    }

    public void setSourcesEmissionTableName(String sourcesEmissionTableName) {
        this.sceneDatabaseInputSettings.setSourcesEmissionTableName(sourcesEmissionTableName);
    }

    public boolean isBodyBarrier() {
        return this.bodyBarrier;
    }

    public ProfilerThread getProfilerThread() {
        return this.profilerThread;
    }

    public String getReceiverTableName() {
        return this.receiverTableName;
    }

    public void setProfilerThread(ProfilerThread profilerThread) {
        this.profilerThread = profilerThread;
    }

    public void setComputeRaysOutFactory(IComputeRaysOutFactory computeRaysOutFactory) {
        this.computeRaysOutFactory = computeRaysOutFactory;
    }

    public void setPropagationProcessDataFactory(TableLoader tableLoader) {
        this.tableLoader = tableLoader;
    }

    public TableLoader getPropagationProcessDataFactory() {
        return this.tableLoader;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public SceneWithEmission prepareCell(Connection connection, CellIndex cellIndex, Set<Long> skipReceivers) throws SQLException, IOException {
        Envelope cellEnvelope = this.getCellEnv(cellIndex);
        if (this.verbose) {
            int ij = cellIndex.getLatitudeIndex() * this.gridDim + cellIndex.getLongitudeIndex() + 1;
            WKTWriter roundWKTWriter = new WKTWriter();
            roundWKTWriter.setPrecisionModel(new PrecisionModel(1.0));
            this.logger.info("Begin processing of cell {}/{} Compute domain is:\n {}", new Object[]{ij, this.gridDim * this.gridDim, roundWKTWriter.write(this.geometryFactory.toGeometry(cellEnvelope))});
        }
        return this.tableLoader.create(connection, cellIndex, skipReceivers);
    }

    @Override
    protected Envelope getComputationEnvelope(Connection connection) throws SQLException {
        DBTypes dbTypes = DBUtils.getDBType((Connection)connection);
        Envelope envelopeInternal = GeometryTableUtilities.getEnvelope((Connection)connection, (TableLocation)TableLocation.parse((String)this.receiverTableName, (DBTypes)dbTypes)).getEnvelopeInternal();
        envelopeInternal.expandBy(this.maximumPropagationDistance);
        return envelopeInternal;
    }

    public Map<CellIndex, Integer> searchPopulatedCells(Connection connection) throws SQLException {
        if (this.mainEnvelope == null) {
            throw new IllegalStateException("Call initialize before calling searchPopulatedCells");
        }
        HashMap<CellIndex, Integer> cellIndices = new HashMap<CellIndex, Integer>();
        List geometryFields = GeometryTableUtilities.getGeometryColumnNames((Connection)connection, (TableLocation)TableLocation.parse((String)this.receiverTableName));
        if (geometryFields.isEmpty()) {
            throw new SQLException("The table " + this.receiverTableName + " does not contain a Geometry field, then the extent cannot be computed");
        }
        this.logger.info("Collect all receivers in order to localize populated cells");
        String geometryField = (String)geometryFields.get(0);
        ResultSet rs = connection.createStatement().executeQuery("SELECT " + geometryField + " FROM " + this.receiverTableName);
        STRtree rtree = new STRtree();
        for (int i = 0; i < this.gridDim; ++i) {
            for (int j = 0; j < this.gridDim; ++j) {
                Envelope refEnv = NoiseMapByReceiverMaker.getCellEnv(this.mainEnvelope, i, j, this.getCellWidth(), this.getCellHeight());
                rtree.insert(refEnv, (Object)new CellIndex(j, i));
            }
        }
        try (SpatialResultSet srs = rs.unwrap(SpatialResultSet.class);){
            while (srs.next()) {
                Geometry pt = srs.getGeometry();
                if (pt == null || pt.isEmpty()) continue;
                Coordinate ptCoord = pt.getCoordinate();
                List queryResult = rtree.query(new Envelope(ptCoord));
                for (Object o : queryResult) {
                    if (!(o instanceof CellIndex)) continue;
                    cellIndices.merge((CellIndex)o, 1, Integer::sum);
                }
            }
        }
        return cellIndices;
    }

    public CutPlaneVisitorFactory evaluateCell(Connection connection, CellIndex cellIndex, ProgressVisitor progression, Set<Long> skipReceivers) throws SQLException, IOException {
        SceneWithEmission scene = this.prepareCell(connection, cellIndex, skipReceivers);
        if (this.verbose) {
            this.logger.info(String.format("This computation area contains %d receivers %d sound sources and %d buildings", scene.receivers.size(), scene.sourceGeometries.size(), scene.profileBuilder.getBuildingCount()));
        }
        CutPlaneVisitorFactory computeRaysOut = this.computeRaysOutFactory.create(scene);
        PathFinder computeRays = new PathFinder((Scene)scene, progression);
        if (this.profilerThread != null) {
            computeRays.setProfilerThread(this.profilerThread);
        }
        if (this.threadCount > 0) {
            computeRays.setThreadCount(this.threadCount);
        }
        if (!this.receiverHasAbsoluteZCoordinates) {
            computeRays.makeReceiverRelativeZToAbsolute();
        }
        if (!this.sourceHasAbsoluteZCoordinates) {
            computeRays.makeSourceRelativeZToAbsolute();
        }
        computeRays.run(computeRaysOut);
        return computeRaysOut;
    }

    public TableLoader getTableLoader() {
        return this.tableLoader;
    }

    @Override
    public void initialize(Connection connection, ProgressVisitor progression) throws SQLException {
        super.initialize(connection, progression);
        this.tableLoader.initialize(connection, this);
        this.computeRaysOutFactory.initialize(connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(Connection connection, ProgressVisitor progressLogger) throws SQLException {
        this.initialize(connection, progressLogger);
        HashSet<Long> receivers = new HashSet<Long>();
        Map<CellIndex, Integer> cells = this.searchPopulatedCells(connection);
        ProgressVisitor progressVisitor = progressLogger.subProcess(cells.size());
        try {
            this.computeRaysOutFactory.start(progressVisitor);
            for (CellIndex cellIndex : new TreeSet<CellIndex>(cells.keySet())) {
                try {
                    this.evaluateCell(connection, cellIndex, progressVisitor, receivers);
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                    return;
                }
            }
        }
        finally {
            this.computeRaysOutFactory.stop();
        }
    }

    public static interface IComputeRaysOutFactory {
        public void initialize(Connection var1, NoiseMapByReceiverMaker var2) throws SQLException;

        public void start(ProgressVisitor var1) throws SQLException;

        public void stop() throws SQLException;

        public CutPlaneVisitorFactory create(SceneWithEmission var1);
    }

    public static interface TableLoader {
        public void initialize(Connection var1, NoiseMapByReceiverMaker var2) throws SQLException;

        public SceneWithEmission create(Connection var1, CellIndex var2, Set<Long> var3) throws SQLException;
    }
}

