/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SpatialResultSet;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.Tuple;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.noise_planet.noisemodelling.jdbc.GridMapMaker;
import org.noise_planet.noisemodelling.jdbc.input.DefaultTableLoader;
import org.noise_planet.noisemodelling.pathfinder.delaunay.LayerDelaunay;
import org.noise_planet.noisemodelling.pathfinder.delaunay.LayerDelaunayError;
import org.noise_planet.noisemodelling.pathfinder.delaunay.LayerTinfour;
import org.noise_planet.noisemodelling.pathfinder.delaunay.Triangle;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Building;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Wall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelaunayReceiversMaker
extends GridMapMaker {
    private static final int BATCH_MAX_SIZE = 100;
    private Logger logger = LoggerFactory.getLogger(DelaunayReceiversMaker.class);
    private double roadWidth = 2.0;
    private double maximumArea = 75.0;
    private long nbreceivers = 0L;
    private double receiverHeight = 1.6;
    private double buildingBuffer = 2.0;
    private String exceptionDumpFolder = "";
    private AtomicInteger constraintId = new AtomicInteger(1);
    private double epsilon = 1.0E-6;
    private double geometrySimplificationDistance = 1.0;
    private boolean isoSurfaceInBuildings = false;

    public DelaunayReceiversMaker(String buildingsTableName, String sourcesTableName) {
        super(buildingsTableName, sourcesTableName);
    }

    public boolean isIsoSurfaceInBuildings() {
        return this.isoSurfaceInBuildings;
    }

    public void setIsoSurfaceInBuildings(boolean isoSurfaceInBuildings) {
        this.isoSurfaceInBuildings = isoSurfaceInBuildings;
    }

    public void run(Connection connection, String verticesTableName, String triangleTableName) throws SQLException {
        this.initialize(connection, (ProgressVisitor)new EmptyProgressVisitor());
        AtomicInteger pk = new AtomicInteger(0);
        for (int i = 0; i < this.getGridDim(); ++i) {
            for (int j = 0; j < this.getGridDim(); ++j) {
                try {
                    this.generateReceivers(connection, i, j, verticesTableName, triangleTableName, pk);
                    continue;
                }
                catch (IOException | LayerDelaunayError ex) {
                    throw new SQLException(ex);
                }
            }
        }
    }

    public String getExceptionDumpFolder() {
        return this.exceptionDumpFolder;
    }

    public void setExceptionDumpFolder(String exceptionDumpFolder) {
        this.exceptionDumpFolder = exceptionDumpFolder;
    }

    public double getBuildingBuffer() {
        return this.buildingBuffer;
    }

    public void setBuildingBuffer(double buildingBuffer) {
        this.buildingBuffer = buildingBuffer;
    }

    private void explodeAndAddPolygon(Geometry intersectedGeometry, LayerDelaunay delaunayTool) throws LayerDelaunayError {
        if (intersectedGeometry instanceof GeometryCollection) {
            for (int j = 0; j < intersectedGeometry.getNumGeometries(); ++j) {
                Geometry subGeom = intersectedGeometry.getGeometryN(j);
                this.explodeAndAddPolygon(subGeom, delaunayTool);
            }
        } else if (intersectedGeometry instanceof Polygon && !intersectedGeometry.isEmpty()) {
            delaunayTool.addPolygon((Polygon)intersectedGeometry, this.constraintId.getAndAdd(1));
        }
    }

    private Geometry merge(LinkedList<Geometry> toUnite, double bufferSize) {
        Geometry[] geoArray = new Geometry[toUnite.size()];
        toUnite.toArray(geoArray);
        GeometryCollection polygonCollection = this.geometryFactory.createGeometryCollection(geoArray);
        BufferOp bufferOp = new BufferOp((Geometry)polygonCollection, new BufferParameters(8, 3, 2, 5.0));
        return bufferOp.getResultGeometry(bufferSize);
    }

    private void feedDelaunay(List<Building> buildings, LayerDelaunay delaunayTool, Envelope boundingBoxFilter, double srcDistance, LinkedList<LineString> delaunaySegments, double minRecDist, double buildingBuffer) throws LayerDelaunayError {
        Envelope extendedEnvelope = new Envelope(boundingBoxFilter);
        extendedEnvelope.expandBy(srcDistance * 2.0);
        Geometry linearRing = this.geometryFactory.toGeometry(boundingBoxFilter);
        if (!(linearRing instanceof Polygon)) {
            return;
        }
        Polygon boundingBox = (Polygon)linearRing;
        LinkedList<Geometry> toUnite = new LinkedList<Geometry>();
        Envelope fetchBox = new Envelope(boundingBoxFilter);
        fetchBox.expandBy(buildingBuffer);
        Geometry fetchGeometry = this.geometryFactory.toGeometry(fetchBox);
        for (Building building : buildings) {
            if (!(building.getGeometry().distance(fetchGeometry) < buildingBuffer)) continue;
            toUnite.add((Geometry)building.getGeometry());
        }
        LinkedList<Geometry> toUniteFinal = new LinkedList<Geometry>();
        if (!toUnite.isEmpty()) {
            Geometry bufferBuildings = this.merge(toUnite, buildingBuffer);
            if ((bufferBuildings = TopologyPreservingSimplifier.simplify((Geometry)bufferBuildings, (double)this.geometrySimplificationDistance)).getNumPoints() > 3) {
                if (this.maximumArea > 1.0) {
                    double triangleSide = 2.0 * Math.pow(this.maximumArea, 0.5) / Math.pow(3.0, 0.25);
                    bufferBuildings = Densifier.densify((Geometry)bufferBuildings, (double)triangleSide);
                }
                toUniteFinal.add(bufferBuildings);
            }
        }
        Polygon geom1 = this.geometryFactory.createPolygon();
        Polygon geom2 = this.geometryFactory.createPolygon();
        try {
            LinkedList<LineString> toUniteRoads;
            if (minRecDist > 0.01 && !(toUniteRoads = new LinkedList<LineString>(delaunaySegments)).isEmpty()) {
                Geometry bufferRoads = this.merge(toUniteRoads, minRecDist / 2.0);
                bufferRoads = TopologyPreservingSimplifier.simplify((Geometry)bufferRoads, (double)this.geometrySimplificationDistance);
                if (this.maximumArea > 1.0) {
                    double triangleSide = 2.0 * Math.pow(this.maximumArea, 0.5) / Math.pow(3.0, 0.25);
                    bufferRoads = Densifier.densify((Geometry)bufferRoads, (double)triangleSide);
                }
                toUniteFinal.add(bufferRoads);
            }
            Geometry union = this.merge(toUniteFinal, 0.0);
            geom1 = union;
            geom2 = boundingBox;
            union = union.intersection((Geometry)boundingBox);
            this.explodeAndAddPolygon(union, delaunayTool);
        }
        catch (TopologyException ex) {
            WKTWriter wktWriter = new WKTWriter(3);
            this.logger.error(String.format("Error with input geometries\n%s\n%s", wktWriter.write((Geometry)geom1), wktWriter.write((Geometry)geom2)), (Throwable)ex);
            throw ex;
        }
    }

    public void computeDelaunay(LayerDelaunay cellMesh, Envelope mainEnvelope, int cellI, int cellJ, double maxSrcDist, Collection<Geometry> sources, double minRecDist, double maximumArea, double buildingBuffer, List<Building> buildings) throws LayerDelaunayError {
        Envelope cellEnvelope = DelaunayReceiversMaker.getCellEnv(mainEnvelope, cellI, cellJ, this.getCellWidth(), this.getCellHeight());
        Geometry cellEnvelopeGeometry = new GeometryFactory().toGeometry(cellEnvelope);
        Envelope expandedCellEnvelop = new Envelope(cellEnvelope);
        expandedCellEnvelop.expandBy(maxSrcDist);
        LinkedList<LineString> delaunaySegments = new LinkedList<LineString>();
        if (minRecDist > 0.1) {
            for (Geometry sourceGeometry : sources) {
                Envelope ptEnv = sourceGeometry.getEnvelopeInternal();
                if (!ptEnv.intersects(expandedCellEnvelop)) continue;
                if (sourceGeometry instanceof Point) {
                    cellMesh.addPolygon((Polygon)cellEnvelopeGeometry.intersection(sourceGeometry.buffer(minRecDist, 3)), 1);
                    continue;
                }
                if (sourceGeometry instanceof LineString) {
                    delaunaySegments.add((LineString)sourceGeometry);
                    continue;
                }
                if (!(sourceGeometry instanceof MultiLineString)) continue;
                int nbLineString = sourceGeometry.getNumGeometries();
                for (int idLineString = 0; idLineString < nbLineString; ++idLineString) {
                    delaunaySegments.add((LineString)sourceGeometry.getGeometryN(idLineString));
                }
            }
        }
        this.feedDelaunay(buildings, cellMesh, cellEnvelope, maxSrcDist, delaunaySegments, minRecDist, buildingBuffer);
        this.logger.info("Begin delaunay");
        cellMesh.setRetrieveNeighbors(false);
        if (maximumArea > 1.0) {
            Coordinate[] points;
            double triangleSide = 2.0 * Math.pow(maximumArea, 0.5) / Math.pow(3.0, 0.25);
            Polygon polygon = (Polygon)Densifier.densify((Geometry)new GeometryFactory().toGeometry(cellEnvelope), (double)triangleSide);
            for (Coordinate point : points = polygon.getExteriorRing().getCoordinates()) {
                cellMesh.addVertex(point);
            }
        } else {
            Coordinate[] points;
            Polygon polygon = (Polygon)new GeometryFactory().toGeometry(cellEnvelope);
            for (Coordinate point : points = polygon.getExteriorRing().getCoordinates()) {
                cellMesh.addVertex(point);
            }
        }
        cellMesh.processDelaunay();
        this.logger.info("End delaunay");
    }

    @Override
    protected Envelope getComputationEnvelope(Connection connection) throws SQLException {
        Envelope computationEnvelope = new Envelope();
        DBTypes dbTypes = DBUtils.getDBType((Connection)connection);
        if (!this.sourcesTableName.isEmpty() && JDBCUtilities.getRowCount((Connection)connection, (String)this.sourcesTableName) > 0) {
            computationEnvelope.expandToInclude(GeometryTableUtilities.getEnvelope((Connection)connection, (TableLocation)TableLocation.parse((String)this.sourcesTableName, (DBTypes)dbTypes)).getEnvelopeInternal());
        }
        if (!this.buildingTableParameters.buildingsTableName.isEmpty() && JDBCUtilities.getRowCount((Connection)connection, (String)this.buildingTableParameters.buildingsTableName) > 0) {
            computationEnvelope.expandToInclude(GeometryTableUtilities.getEnvelope((Connection)connection, (TableLocation)TableLocation.parse((String)this.buildingTableParameters.buildingsTableName, (DBTypes)dbTypes)).getEnvelopeInternal());
        }
        return computationEnvelope;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public double getGeometrySimplificationDistance() {
        return this.geometrySimplificationDistance;
    }

    public void setGeometrySimplificationDistance(double geometrySimplificationDistance) {
        this.geometrySimplificationDistance = geometrySimplificationDistance;
    }

    public static void generateResultTable(Connection connection, String receiverTableName, String trianglesTableName, AtomicInteger receiverPK, List<Coordinate> vertices, GeometryFactory geometryFactory, List<Triangle> triangles, int cellI, int cellJ, int gridDim) throws SQLException {
        Statement st;
        if (!JDBCUtilities.tableExists((Connection)connection, (String)receiverTableName)) {
            st = connection.createStatement();
            st.execute("CREATE TABLE " + String.valueOf(TableLocation.parse((String)receiverTableName)) + "(pk serial NOT NULL, the_geom geometry not null, PRIMARY KEY (PK))");
        }
        if (!JDBCUtilities.tableExists((Connection)connection, (String)trianglesTableName)) {
            st = connection.createStatement();
            st.execute("CREATE TABLE " + String.valueOf(TableLocation.parse((String)trianglesTableName)) + "(pk serial NOT NULL, the_geom geometry , PK_1 integer not null, PK_2 integer not null, PK_3 integer not null, cell_id integer not null, PRIMARY KEY (PK))");
        }
        int receiverPkOffset = receiverPK.get();
        PreparedStatement ps = connection.prepareStatement("INSERT INTO " + String.valueOf(TableLocation.parse((String)receiverTableName)) + " VALUES (?, ?);");
        int batchSize = 0;
        for (Coordinate v : vertices) {
            ps.setInt(1, receiverPK.getAndAdd(1));
            ps.setObject(2, geometryFactory.createPoint(v));
            ps.addBatch();
            if (++batchSize < 100) continue;
            ps.executeBatch();
            ps.clearBatch();
            batchSize = 0;
        }
        if (batchSize > 0) {
            ps.executeBatch();
        }
        ps = connection.prepareStatement("INSERT INTO " + String.valueOf(TableLocation.parse((String)trianglesTableName)) + "(the_geom, PK_1, PK_2, PK_3, CELL_ID) VALUES (?, ?, ?, ?, ?);");
        batchSize = 0;
        for (Triangle t : triangles) {
            ps.setObject(1, geometryFactory.createPolygon(new Coordinate[]{vertices.get(t.getA()), vertices.get(t.getB()), vertices.get(t.getC()), vertices.get(t.getA())}));
            ps.setInt(2, t.getA() + receiverPkOffset);
            ps.setInt(3, t.getC() + receiverPkOffset);
            ps.setInt(4, t.getB() + receiverPkOffset);
            ps.setInt(5, cellI * gridDim + cellJ);
            ps.addBatch();
            if (++batchSize < 100) continue;
            ps.executeBatch();
            ps.clearBatch();
            batchSize = 0;
        }
        if (batchSize > 0) {
            ps.executeBatch();
        }
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchCellSource(Connection connection, Envelope fetchEnvelope, boolean doIntersection, List<Geometry> sourceGeometries) throws SQLException {
        DBTypes dbType = DBUtils.getDBType((Connection)connection.unwrap(Connection.class));
        TableLocation sourceTableIdentifier = TableLocation.parse((String)this.sourcesTableName, (DBTypes)dbType);
        List geomFields = GeometryTableUtilities.getGeometryColumnNames((Connection)connection, (TableLocation)sourceTableIdentifier);
        if (geomFields.isEmpty()) {
            throw new SQLException(String.format("The table %s does not exists or does not contain a geometry field", sourceTableIdentifier));
        }
        String sourceGeomName = (String)geomFields.get(0);
        Geometry domainConstraint = this.geometryFactory.toGeometry(fetchEnvelope);
        Tuple primaryKey = JDBCUtilities.getIntegerPrimaryKeyNameAndIndex((Connection)connection.unwrap(Connection.class), (TableLocation)new TableLocation(this.sourcesTableName, dbType));
        int pkIndex = (Integer)primaryKey.second();
        if (pkIndex < 1) {
            throw new IllegalArgumentException(String.format("Source table %s does not contain a primary key", sourceTableIdentifier));
        }
        try (PreparedStatement st = connection.prepareStatement("SELECT * FROM " + this.sourcesTableName + " WHERE " + TableLocation.quoteIdentifier((String)sourceGeomName) + " && ?::geometry");){
            st.setObject(1, this.geometryFactory.toGeometry(fetchEnvelope));
            st.setFetchSize(300);
            boolean autoCommit = connection.getAutoCommit();
            if (autoCommit) {
                connection.setAutoCommit(false);
            }
            st.setFetchDirection(1000);
            try (SpatialResultSet rs = st.executeQuery().unwrap(SpatialResultSet.class);){
                while (rs.next()) {
                    Geometry geo = rs.getGeometry();
                    if (geo == null) continue;
                    if (doIntersection) {
                        geo = domainConstraint.intersection(geo);
                    }
                    if (geo.isEmpty()) continue;
                    sourceGeometries.add(geo);
                }
            }
            finally {
                if (autoCommit) {
                    connection.setAutoCommit(true);
                }
            }
        }
    }

    public void generateReceivers(Connection connection, int cellI, int cellJ, String receiverTableName, String trianglesTableName, AtomicInteger receiverPK) throws SQLException, LayerDelaunayError, IOException {
        ArrayList<Triangle> triangles;
        int ij = cellI * this.gridDim + cellJ + 1;
        if (this.verbose) {
            this.logger.info("Begin processing of cell " + ij + " / " + this.gridDim * this.gridDim);
        }
        Envelope cellEnvelope = DelaunayReceiversMaker.getCellEnv(this.mainEnvelope, cellI, cellJ, this.getCellWidth(), this.getCellHeight());
        LinkedList<Geometry> sourceDelaunayGeometries = new LinkedList<Geometry>();
        if (!this.sourcesTableName.isEmpty()) {
            this.fetchCellSource(connection, cellEnvelope, true, sourceDelaunayGeometries);
        }
        LinkedList<Building> buildings = new LinkedList<Building>();
        LinkedList<Wall> walls = new LinkedList<Wall>();
        Envelope expandedCell = new Envelope(cellEnvelope);
        expandedCell.expandBy(this.buildingBuffer);
        DefaultTableLoader.fetchCellBuildings(connection, this.buildingTableParameters, cellEnvelope, buildings, walls, this.geometryFactory);
        LayerTinfour cellMesh = new LayerTinfour();
        cellMesh.setEpsilon(this.epsilon);
        cellMesh.setDumpFolder(this.exceptionDumpFolder);
        cellMesh.setMaxArea(Double.valueOf(this.maximumArea > 1.0 ? this.maximumArea : 0.0));
        try {
            this.computeDelaunay((LayerDelaunay)cellMesh, this.mainEnvelope, cellI, cellJ, this.maximumPropagationDistance, sourceDelaunayGeometries, this.roadWidth, this.maximumArea, this.buildingBuffer, buildings);
        }
        catch (LayerDelaunayError err) {
            throw new SQLException(err.getLocalizedMessage(), err);
        }
        sourceDelaunayGeometries.clear();
        ArrayList<Coordinate> vertices = new ArrayList<Coordinate>(cellMesh.getVertices().size());
        for (Coordinate vertex : cellMesh.getVertices()) {
            Coordinate translatedVertex = new Coordinate(vertex);
            double z = this.receiverHeight;
            translatedVertex.setOrdinate(2, z);
            vertices.add(translatedVertex);
        }
        if (!this.isoSurfaceInBuildings) {
            triangles = new ArrayList<Triangle>(cellMesh.getTriangles().size());
            for (Triangle triangle : cellMesh.getTriangles()) {
                if (triangle.getAttribute() != 0) continue;
                triangles.add(triangle);
            }
        } else {
            triangles = cellMesh.getTriangles();
        }
        this.nbreceivers += (long)vertices.size();
        DelaunayReceiversMaker.generateResultTable(connection, receiverTableName, trianglesTableName, receiverPK, vertices, this.geometryFactory, triangles, cellI, cellJ, this.gridDim);
    }

    public double getRoadWidth() {
        return this.roadWidth;
    }

    public void setRoadWidth(double roadWidth) {
        this.roadWidth = roadWidth;
    }

    public double getMaximumArea() {
        return this.maximumArea;
    }

    public void setMaximumArea(double maximumArea) {
        this.maximumArea = maximumArea;
    }

    public double getReceiverHeight() {
        return this.receiverHeight;
    }

    public void setReceiverHeight(double receiverHeight) {
        this.receiverHeight = receiverHeight;
    }

    public long getNbreceivers() {
        return this.nbreceivers;
    }
}

