/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.cache.memcached;

import java.lang.reflect.Type;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import org.noear.wood.cache.ICacheServiceEx;
import org.noear.wood.cache.memcached.TextUtils;
import org.noear.wood.utils.EncryptUtils;

public class MemCache
implements ICacheServiceEx {
    private String _cacheKeyHead;
    private int _defaultSeconds;
    private MemcachedClient _cache = null;

    public MemCache(String keyHeader, int defSeconds, String server, String user, String password) {
        Properties prop = new Properties();
        prop.setProperty("server", server);
        if (user != null) {
            prop.setProperty("user", user);
        }
        if (password != null) {
            prop.setProperty("password", password);
        }
        this.initDo(prop, keyHeader, defSeconds);
    }

    public MemCache(Properties prop) {
        this.initDo(prop, prop.getProperty("keyHeader"), 0);
    }

    public MemCache(Properties prop, String keyHeader, int defSeconds) {
        this.initDo(prop, keyHeader, defSeconds);
    }

    private void initDo(Properties prop, String keyHeader, int defSeconds) {
        String server = prop.getProperty("server");
        String user = prop.getProperty("user");
        String password = prop.getProperty("password");
        if (defSeconds == 0) {
            String defSeconds_str = prop.getProperty("defSeconds");
            defSeconds = defSeconds_str == null ? 60 : Integer.parseInt(defSeconds_str);
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        if (this._defaultSeconds < 1) {
            this._defaultSeconds = 30;
        }
        try {
            if (TextUtils.isEmpty(user) || TextUtils.isEmpty(password)) {
                this._cache = new MemcachedClient(new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).build(), AddrUtil.getAddresses((String)server));
            } else {
                AuthDescriptor ad = new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(user, password));
                this._cache = new MemcachedClient(new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setAuthDescriptor(ad).build(), AddrUtil.getAddresses((String)server));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void store(String key, Object obj, int seconds) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            try {
                if (seconds > 0) {
                    this._cache.set(newKey, seconds, obj);
                } else {
                    this._cache.set(newKey, this.getDefalutSeconds(), obj);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public <T> T get(String key, Type type) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            try {
                return (T)this._cache.get(newKey);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public void remove(String key) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            this._cache.delete(newKey);
        }
    }

    public int getDefalutSeconds() {
        return this._defaultSeconds;
    }

    public String getCacheKeyHead() {
        return this._cacheKeyHead;
    }

    private String newKey(String key) {
        return this._cacheKeyHead + "$" + EncryptUtils.md5((String)key);
    }
}

