/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import org.noear.water.utils.ext.Act0Ex;

public class TaskUtils {
    public static void run(ITask task) {
        new Thread(() -> TaskUtils.doRun(task), "Simple task").start();
    }

    public static void run(long interval, Act0Ex runnable) {
        TaskUtils.run(new TaskImp(interval, 0L, runnable));
    }

    public static void run(long interval, long delayed, Act0Ex runnable) {
        TaskUtils.run(new TaskImp(interval, delayed, runnable));
    }

    private static void doRun(ITask task) {
        if (task.getDelayed() > 0L) {
            try {
                Thread.sleep(task.getDelayed());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        while (true) {
            try {
                while (true) {
                    long time_start = System.currentTimeMillis();
                    task.exec();
                    long time_end = System.currentTimeMillis();
                    if (task.getInterval() == 0L) {
                        return;
                    }
                    if (time_end - time_start >= task.getInterval()) continue;
                    Thread.sleep(task.getInterval());
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected static class TaskImp
    implements ITask {
        long interval;
        long delayed;
        Act0Ex runnable;

        TaskImp(long interval, long delayed, Act0Ex runnable) {
            this.interval = interval;
            this.delayed = delayed;
            this.runnable = runnable;
        }

        @Override
        public long getInterval() {
            return this.interval;
        }

        @Override
        public long getDelayed() {
            return this.delayed;
        }

        @Override
        public void exec() throws Throwable {
            this.runnable.run();
        }
    }

    public static interface ITask {
        public long getInterval();

        public void exec() throws Throwable;

        default public long getDelayed() {
            return 0L;
        }
    }
}

