/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.RuntimeStatus;

public class RuntimeUtils {
    private static RuntimeStatus status = new RuntimeStatus();

    public static RuntimeStatus getStatus() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        OperatingSystemMXBean systemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        Runtime runtime = Runtime.getRuntime();
        RuntimeUtils.status.memoryTotal = RuntimeUtils.byteToM(runtime.totalMemory());
        RuntimeUtils.status.memoryUsed = RuntimeUtils.byteToM(runtime.totalMemory() - runtime.freeMemory());
        String memoryMax = new DecimalFormat("#.##").format((double)systemMXBean.getTotalPhysicalMemorySize() / 1024.0 / 1024.0 / 1024.0) + "G";
        String memoryFree = new DecimalFormat("#.##").format((double)systemMXBean.getFreePhysicalMemorySize() / 1024.0 / 1024.0 / 1024.0) + "G";
        RuntimeUtils.status.system.put("arch", systemMXBean.getArch());
        RuntimeUtils.status.system.put("systemLoadAverage", systemMXBean.getSystemLoadAverage());
        RuntimeUtils.status.system.put("availableProcessors", systemMXBean.getAvailableProcessors());
        RuntimeUtils.status.system.put("memoryMax", memoryMax);
        RuntimeUtils.status.system.put("memoryFree", memoryFree);
        ArrayList<Map<String, Object>> memoryPools = new ArrayList<Map<String, Object>>();
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        if (pools != null && !pools.isEmpty()) {
            for (MemoryPoolMXBean pool : pools) {
                MemoryUsage usage = pool.getUsage();
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("name", pool.getName());
                map.put("max", RuntimeUtils.byteToM(usage.getMax()));
                map.put("init", RuntimeUtils.byteToM(usage.getInit()));
                map.put("used", RuntimeUtils.byteToM(usage.getUsed()));
                memoryPools.add(map);
            }
        }
        RuntimeUtils.status.memoryPools = memoryPools;
        RuntimeUtils.status.timeElapsed = runtimeMXBean.getUptime();
        RuntimeUtils.status.threadCount = threadMXBean.getThreadCount();
        RuntimeUtils.status.threadPeakCount = threadMXBean.getPeakThreadCount();
        RuntimeUtils.status.threadDaemonCount = threadMXBean.getDaemonThreadCount();
        if (RuntimeUtils.status.pid == null) {
            RuntimeUtils.status.memoryMax = RuntimeUtils.byteToM(runtime.maxMemory());
            RuntimeUtils.status.timeStart = new Datetime(runtimeMXBean.getStartTime()).toString();
            RuntimeUtils.status.pid = runtimeMXBean.getName();
            RuntimeUtils.status.os = System.getProperty("os.name");
            RuntimeUtils.status.vm = System.getProperty("java.vm.vendor") + " / " + System.getProperty("java.vm.name") + " / " + System.getProperty("java.vm.version");
        }
        return status;
    }

    public static long byteToM(long bytes) {
        long kb = bytes / 1024L / 1024L;
        return kb;
    }
}

