/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.noear.water.utils.PropertiesJson;
import org.noear.water.utils.PropertiesYaml;
import org.noear.water.utils.TextUtils;

public class PropUtils {
    public static Properties build(String text) {
        try {
            return PropUtils.build0(text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Properties build0(String text) throws IOException {
        if (TextUtils.isEmpty(text)) {
            return new Properties();
        }
        text = text.trim();
        int idx1 = text.indexOf("=");
        int idx2 = text.indexOf(":");
        if (text.startsWith("{") && text.endsWith("}")) {
            PropertiesJson tmp = new PropertiesJson();
            tmp.loadJson(text);
            return tmp;
        }
        if (text.startsWith("[") && text.endsWith("]")) {
            PropertiesJson tmp = new PropertiesJson();
            tmp.loadJson(text);
            return tmp;
        }
        if (idx1 > 0 && (idx1 < idx2 || idx2 < 0)) {
            Properties tmp = new Properties();
            tmp.load(new StringReader(text));
            return tmp;
        }
        if (idx2 > 0 && (idx2 < idx1 || idx1 < 0)) {
            PropertiesYaml tmp = new PropertiesYaml();
            tmp.loadYml(new StringReader(text));
            return tmp;
        }
        return new Properties();
    }
}

