/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.function.BiConsumer;
import org.noear.water.utils.RunUtils;

public class PingUtils {
    public static void ping(String address) throws Exception {
        PingUtils.ping(address, 3000);
    }

    public static void ping(String address, int millis) throws Exception {
        if (address.contains(":")) {
            String host = address.split(":")[0];
            int port = Integer.parseInt(address.split(":")[1]);
            try (Socket socket = new Socket();){
                InetSocketAddress addr = new InetSocketAddress(host, port);
                socket.connect(addr, millis);
            }
        } else {
            InetAddress.getByName(address).isReachable(millis);
        }
    }

    public static void pingAsyn(String address, int millis, BiConsumer<Boolean, Throwable> callback) {
        RunUtils.runAsyn(() -> {
            try {
                PingUtils.ping(address, millis);
                callback.accept(true, null);
            }
            catch (Throwable e) {
                callback.accept(false, e);
            }
        });
    }
}

