/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.noear.water.utils.Base64Utils;

public class GzipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gZip(String input) throws IOException {
        byte[] bytes = null;
        DeflaterOutputStream gzip = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(bos);
            gzip.write(input.getBytes(StandardCharsets.UTF_8));
            ((GZIPOutputStream)gzip).finish();
            gzip.close();
            bytes = bos.toByteArray();
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (gzip != null) {
                gzip.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return Base64Utils.encodeByte(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unGZip(String input) throws IOException {
        String out = input;
        GZIPInputStream gzip = null;
        ByteArrayOutputStream bos = null;
        try {
            int num;
            ByteArrayInputStream bis = new ByteArrayInputStream(Base64Utils.decodeByte(input));
            gzip = new GZIPInputStream(bis);
            byte[] buf = new byte[1024];
            bos = new ByteArrayOutputStream();
            while ((num = gzip.read(buf, 0, buf.length)) != -1) {
                bos.write(buf, 0, num);
            }
            byte[] bytes = bos.toByteArray();
            out = new String(bytes, StandardCharsets.UTF_8);
            gzip.close();
            bis.close();
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (gzip != null) {
                gzip.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return out;
    }
}

