/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.noear.snack.core.exts.ClassWrap;
import org.noear.snack.core.exts.FieldWrap;
import org.noear.water.utils.ConvertUtil;
import org.noear.water.utils.TextUtils;
import org.noear.wood.DbContext;
import org.noear.wood.DbDataSource;

public class DsUtils {
    public static DbContext getDb(Properties prop, boolean pool) {
        if (prop.size() < 4) {
            throw new RuntimeException("Data source configuration error!");
        }
        String url = prop.getProperty("url");
        if (TextUtils.isEmpty(url)) {
            return null;
        }
        String schema = prop.getProperty("schema");
        return new DbContext(DsUtils.getDs(prop, pool), schema);
    }

    public static DataSource getDs(Properties prop, boolean pool) {
        String url = prop.getProperty("url");
        if (TextUtils.isEmpty(url)) {
            return null;
        }
        String username = prop.getProperty("username");
        String password = prop.getProperty("password");
        String driverClassName = prop.getProperty("driverClassName");
        if (pool) {
            HikariDataSource source = new HikariDataSource();
            for (FieldWrap fw : ClassWrap.get(HikariDataSource.class).fieldAllWraps()) {
                String valStr = prop.getProperty(fw.name());
                if (!TextUtils.isNotEmpty(valStr)) continue;
                Object val = ConvertUtil.to(fw.type, valStr);
                fw.setValue((Object)source, val);
            }
            if (TextUtils.isNotEmpty(url)) {
                source.setJdbcUrl(url);
            }
            return source;
        }
        if (TextUtils.isNotEmpty(driverClassName)) {
            try {
                Class.forName(driverClassName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return new DbDataSource(url, username, password);
    }
}

