/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.noear.mongox.MgContext;
import org.noear.redisx.RedisClient;
import org.noear.water.model.ConfigM;
import org.noear.water.model.PropertiesM;
import org.noear.water.utils.TextUtils;
import org.noear.wood.DbContext;

public class ConfigResolver {
    private static Map<String, RedisClient> toRedisMap = new HashMap<String, RedisClient>();
    private static Map<String, MgContext> toMongoMap = new HashMap<String, MgContext>();
    private static Map<String, DbContext> toDbMap = new HashMap<String, DbContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedisClient toRedis(ConfigM cfg, int db) {
        if (TextUtils.isEmpty(cfg.value)) {
            return null;
        }
        String cacheKey = cfg.value + "::" + db;
        RedisClient rd = toRedisMap.get(cacheKey);
        if (rd == null) {
            String string = cacheKey.intern();
            synchronized (string) {
                rd = toRedisMap.get(cacheKey);
                if (rd == null) {
                    rd = new RedisClient((Properties)cfg.getProp(), db);
                    toRedisMap.put(cacheKey, rd);
                }
            }
        }
        return rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MgContext toMongo(ConfigM cfg, String db) {
        if (TextUtils.isEmpty(cfg.value)) {
            return null;
        }
        String cacheKey = cfg.value + "::" + db;
        MgContext mg = toMongoMap.get(cacheKey);
        if (mg == null) {
            String string = cacheKey.intern();
            synchronized (string) {
                mg = toMongoMap.get(cacheKey);
                if (mg == null) {
                    mg = new MgContext((Properties)cfg.getProp(), db);
                    toMongoMap.put(cacheKey, mg);
                }
            }
        }
        return mg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbContext toDb(ConfigM cfg, boolean pool) {
        if (TextUtils.isEmpty(cfg.value)) {
            return null;
        }
        String cacheKey = cfg.value + "::" + pool;
        DbContext db = toDbMap.get(cacheKey);
        if (db == null) {
            String string = cacheKey.intern();
            synchronized (string) {
                db = toDbMap.get(cacheKey);
                if (db == null) {
                    db = ConfigResolver.getDbDo(cfg, pool);
                    toDbMap.put(cacheKey, db);
                }
            }
        }
        return db;
    }

    private static DbContext getDbDo(ConfigM cfg, boolean pool) {
        PropertiesM prop = cfg.getProp();
        String url = prop.getProperty("url");
        if (TextUtils.isEmpty(url)) {
            return null;
        }
        String schema = prop.getProperty("schema");
        return new DbContext(cfg.getDs(pool), schema);
    }
}

