/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.track;

import org.noear.redisx.RedisClient;
import org.noear.redisx.RedisSession;
import org.noear.redisx.model.LocalHash;
import org.noear.water.track.TrackEvent;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.TextUtils;

public class TrackUtils {
    public static void track(RedisClient redisX, String service, String tag, String name, long timespan, String _node, String _from) {
        TrackUtils.track(redisX, service, tag, name, timespan);
        if (!TextUtils.isEmpty(_node)) {
            TrackUtils.track(redisX, "_service", service, _node, timespan);
        }
        if (!TextUtils.isEmpty(_from)) {
            TrackUtils.track(redisX, "_from", service, _from, timespan);
        }
    }

    public static void track(RedisClient redisX, String service, String tag, String name, long timespan) {
        try {
            TrackUtils.do_track(redisX, service, tag, name, timespan);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void do_track(RedisClient redisX, String service, String tag, String name, long timespan) {
        Datetime now = Datetime.Now();
        StringBuilder sb = new StringBuilder();
        sb.append(service).append("$").append(tag).append("$").append(name);
        String key_idx = sb.toString();
        sb.append("$").append(now.toString("yyyyMMdd"));
        String key_date = sb.toString();
        sb.append(now.toString("HH"));
        String key_hour = sb.toString();
        sb.append(now.toString("mm"));
        String key_minute = sb.toString();
        String key_minute_bef = now.addMinute(-1).toString("yyyyMMddHHmm");
        String log_time = now.toString("yyyy-MM-dd HH:mm:ss");
        redisX.open(ru -> {
            long average = TrackUtils.do_track_key_minute(ru, key_minute_bef, key_minute, timespan);
            TrackUtils.do_track_key_hour(ru, key_hour, timespan);
            TrackUtils.do_track_key_date(ru, key_date, timespan, average);
            ru.key("monitor_keys").expire(31536000).hashSet(key_idx, log_time);
        });
    }

    private static long do_track_key_minute(RedisSession ru, String rdkey_bef, String rdkey, long timespan) {
        LocalHash hash = ru.key(rdkey_bef).hashGetAll();
        long total_time0 = hash.getAsLong("total_time");
        long total_num0 = hash.getAsLong("total_num");
        ru.key(rdkey).expire(180);
        long total_time = ru.hashIncr("total_time", timespan);
        long total_num = ru.hashIncr("total_num", 1L);
        long average = (total_time + total_time0) / (total_num + total_num0);
        return average;
    }

    private static void do_track_key_hour(RedisSession ru, String rdkey, long timespan) {
        LocalHash hash = ru.key(rdkey).hashGetAll();
        ru.key(rdkey).expire(10800);
        long total_time = ru.hashIncr("total_time", timespan);
        long total_num = ru.hashIncr("total_num", 1L);
        if (timespan > 1000L) {
            ru.hashIncr("total_num_slow1", 1L);
        }
        if (timespan > 2000L) {
            ru.hashIncr("total_num_slow2", 1L);
        }
        if (timespan > 5000L) {
            ru.hashIncr("total_num_slow5", 1L);
        }
        long average = total_time / total_num;
        ru.hashSet("average", average);
        long slowest = hash.getAsLong("slowest");
        long fastest = hash.getAsLong("fastest");
        if (timespan > slowest) {
            ru.hashSet("slowest", timespan);
        }
        if (timespan < fastest || fastest == 0L) {
            ru.hashSet("fastest", timespan);
        }
    }

    private static void do_track_key_date(RedisSession ru, String rdkey, long timespan, long average) {
        LocalHash hash = ru.key(rdkey).hashGetAll();
        ru.key(rdkey).expire(86400);
        ru.hashIncr("total_time", timespan);
        ru.hashIncr("total_num", 1L);
        if (timespan > 1000L) {
            ru.hashIncr("total_num_slow1", 1L);
        }
        if (timespan > 2000L) {
            ru.hashIncr("total_num_slow2", 1L);
        }
        if (timespan > 5000L) {
            ru.hashIncr("total_num_slow5", 1L);
        }
        ru.hashSet("average", average);
        long slowest = hash.getAsLong("slowest");
        long fastest = hash.getAsLong("fastest");
        if (timespan > slowest) {
            ru.hashSet("slowest", timespan);
        }
        if (timespan < fastest || fastest == 0L) {
            ru.hashSet("fastest", timespan);
        }
    }

    public static void trackAll(RedisSession ru, String rdKey, TrackEvent mc) {
        Datetime now = Datetime.Now();
        String log_time = now.toString("yyyy-MM-dd HH:mm:ss");
        if ("date".equals(mc.type)) {
            long average = TrackUtils.trackAll_key_minute(ru, mc.key_minute_bef, mc.key_minute, mc);
            TrackUtils.trackAll_key_date(ru, rdKey, mc, average);
        } else {
            TrackUtils.trackAll_key_hour(ru, rdKey, mc);
        }
        ru.key("monitor_keys").expire(31536000).hashSet(mc.group, log_time);
    }

    private static long trackAll_key_minute(RedisSession ru, String rdkey_bef, String rdkey, TrackEvent mc) {
        LocalHash hash = ru.key(rdkey_bef).hashGetAll();
        long total_time0 = hash.getAsLong("total_time");
        long total_num0 = hash.getAsLong("total_num");
        ru.key(rdkey).expire(180);
        long total_time = ru.hashIncr("total_time", mc.total_time());
        long total_num = ru.hashIncr("total_num", mc.total_num());
        long average = (total_time + total_time0) / (total_num + total_num0);
        return average;
    }

    private static void trackAll_key_hour(RedisSession ru, String rdkey, TrackEvent mc) {
        LocalHash hash = ru.key(rdkey).hashGetAll();
        ru.key(rdkey).expire(10800);
        long total_time = ru.hashIncr("total_time", mc.total_time());
        long total_num = ru.hashIncr("total_num", mc.total_num());
        long total_num_slow1 = mc.total_num_slow1();
        long total_num_slow2 = mc.total_num_slow2();
        long total_num_slow5 = mc.total_num_slow5();
        if (total_num_slow1 > 0L) {
            ru.hashIncr("total_num_slow1", total_num_slow1);
        }
        if (total_num_slow2 > 0L) {
            ru.hashIncr("total_num_slow2", total_num_slow2);
        }
        if (total_num_slow5 > 0L) {
            ru.hashIncr("total_num_slow5", total_num_slow5);
        }
        long average = total_time / total_num;
        ru.hashSet("average", average);
        long slowest = hash.getAsLong("slowest");
        long fastest = hash.getAsLong("fastest");
        long slowest2 = mc.slowest();
        long fastest2 = mc.fastest();
        if (slowest2 > slowest) {
            ru.hashSet("slowest", slowest2);
        }
        if (fastest2 < fastest || fastest == 0L) {
            ru.hashSet("fastest", fastest2);
        }
    }

    private static void trackAll_key_date(RedisSession ru, String rdkey, TrackEvent mc, long average) {
        LocalHash hash = ru.key(rdkey).hashGetAll();
        ru.key(rdkey).expire(86400);
        ru.hashIncr("total_time", mc.total_time());
        ru.hashIncr("total_num", mc.total_num());
        long total_num_slow1 = mc.total_num_slow1();
        long total_num_slow2 = mc.total_num_slow2();
        long total_num_slow5 = mc.total_num_slow5();
        if (total_num_slow1 > 0L) {
            ru.hashIncr("total_num_slow1", total_num_slow1);
        }
        if (total_num_slow2 > 0L) {
            ru.hashIncr("total_num_slow2", total_num_slow2);
        }
        if (total_num_slow5 > 0L) {
            ru.hashIncr("total_num_slow5", total_num_slow5);
        }
        ru.hashSet("average", average);
        long slowest = hash.getAsLong("slowest");
        long fastest = hash.getAsLong("fastest");
        long slowest2 = mc.slowest();
        long fastest2 = mc.fastest();
        if (slowest2 > slowest) {
            ru.hashSet("slowest", slowest2);
        }
        if (fastest2 < fastest || fastest == 0L) {
            ru.hashSet("fastest", fastest2);
        }
    }
}

