/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.track;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.noear.redisx.RedisClient;
import org.noear.water.utils.EncryptUtils;
import org.noear.water.utils.TextUtils;

public class TrackNames {
    private static final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    private static final TrackNames singleton = new TrackNames();
    private RedisClient _redisX;
    private Map<String, String> _nameSet = new LinkedHashMap<String, String>();

    public static TrackNames singleton() {
        return singleton;
    }

    public void bind(RedisClient redisX) {
        this._redisX = redisX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNameMd5(String name) {
        if (TextUtils.isEmpty(name)) {
            return "";
        }
        if (name.startsWith("{md5}")) {
            return name;
        }
        String nameMd5 = this._nameSet.get(name);
        if (nameMd5 == null) {
            String string = name.intern();
            synchronized (string) {
                nameMd5 = this._nameSet.get(name);
                if (nameMd5 == null) {
                    nameMd5 = "{md5}" + EncryptUtils.md5(name);
                    this._nameSet.put(name, nameMd5);
                    this.setDo(nameMd5, name);
                }
            }
        }
        return nameMd5;
    }

    public String getName(String nameMd5) {
        if (TextUtils.isEmpty(nameMd5)) {
            return "";
        }
        if (!nameMd5.startsWith("{md5}")) {
            return nameMd5;
        }
        return this.getDo(nameMd5);
    }

    public String getDo(String nameMd5) {
        return (String)this._redisX.openAndGet(ru -> ru.key(nameMd5).get());
    }

    private void setDo(String nameMd5, String name) {
        executor.submit(() -> {
            try {
                this._redisX.open(ru -> ru.key(nameMd5).expire(2592000).set(name));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        });
    }
}

