/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.track;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.water.track.TrackEvent;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.TaskUtils;
import org.noear.water.utils.TextUtils;

public abstract class TrackEventBuffer
implements TaskUtils.ITask {
    private Map<String, TrackEvent> _mainSet = new LinkedHashMap<String, TrackEvent>();
    private Map<String, TrackEvent> _serviceSet = new LinkedHashMap<String, TrackEvent>();
    private Map<String, TrackEvent> _fromSet = new LinkedHashMap<String, TrackEvent>();
    private long interval = 1000L;
    private long interval_min = 100L;

    protected TrackEventBuffer() {
        TaskUtils.run(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrackEvent getOrNew(Map<String, TrackEvent> mSet, String group, String rdkey) {
        TrackEvent tmp = mSet.get(rdkey);
        if (tmp == null) {
            TrackEventBuffer trackEventBuffer = this;
            synchronized (trackEventBuffer) {
                tmp = mSet.get(rdkey);
                if (tmp == null) {
                    tmp = new TrackEvent(group);
                    mSet.put(rdkey, tmp);
                }
            }
        }
        return tmp;
    }

    public void append(String service, String tag, String name, long timespan, String _node, String _from) {
        this.append(service, tag, name, timespan);
        if (!TextUtils.isEmpty(_node)) {
            this.appendNode(service, _node, timespan);
        }
        if (!TextUtils.isEmpty(_from)) {
            this.appendFrom(service, _from, timespan);
        }
    }

    public void appendNode(String service, String _node, long timespan) {
        this.appendDo(this._serviceSet, "_service", service, _node, timespan);
    }

    public void appendFrom(String service, String _from, long timespan) {
        this.appendDo(this._fromSet, "_from", service, _from, timespan);
    }

    public void append(String service, String tag, String name, long timespan) {
        this.appendDo(this._mainSet, service, tag, name, timespan);
    }

    public void appendCount(String service, String tag, String name, long count) {
        this.appendDo(this._mainSet, service, tag, name, count, 0L, 0L, 0L);
    }

    public void appendCount(String service, String tag, String name, long count, long count5) {
        this.appendDo(this._mainSet, service, tag, name, count, 0L, 0L, count5);
    }

    public void appendCount(String service, String tag, String name, long count, long count1, long count2, long count5) {
        this.appendDo(this._mainSet, service, tag, name, count, count1, count2, count5);
    }

    private void appendDo(Map<String, TrackEvent> mSet, String service, String tag, String name, long timespan) {
        try {
            this.appendDo0(mSet, service, tag, name, timespan, 1L, 1L, 1L, 1L);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void appendDo(Map<String, TrackEvent> mSet, String service, String tag, String name, long count, long count1, long count2, long count5) {
        try {
            this.appendDo0(mSet, service, tag, name, -1L, count, count1, count2, count5);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void appendDo0(Map<String, TrackEvent> mSet, String service, String tag, String name, long timespan, long count, long count1, long count2, long count5) {
        Datetime now = Datetime.Now();
        StringBuilder sb = new StringBuilder();
        sb.append(service).append("$").append(tag).append("$").append(name);
        String key_group = sb.toString();
        sb.append("$").append(now.toString("yyyyMMdd"));
        String key_date = sb.toString();
        sb.append(now.toString("HH"));
        String key_hour = sb.toString();
        sb.append(now.toString("mm"));
        String key_minute = sb.toString();
        String key_minute_bef = now.addMinute(-1).toString("yyyyMMddHHmm");
        this.do_track_key(mSet, key_group, key_hour, timespan, "hour", key_minute, key_minute_bef, count, count1, count2, count5);
        this.do_track_key(mSet, key_group, key_date, timespan, "date", key_minute, key_minute_bef, count, count1, count2, count5);
    }

    private void do_track_key(Map<String, TrackEvent> mSet, String group, String rdkey, long timespan, String type, String key_minute, String key_minute_bef, long count, long count1, long count2, long count5) {
        TrackEvent ru = this.getOrNew(mSet, group, rdkey);
        ru.type = type;
        ru.key_minute = key_minute;
        ru.key_minute_bef = key_minute_bef;
        if (timespan < 0L) {
            ru.hashIncr("total_num", count);
            if (count1 > 0L) {
                ru.hashIncr("total_num_slow1", count1);
            }
            if (count2 > 0L) {
                ru.hashIncr("total_num_slow2", count2);
            }
            if (count5 > 0L) {
                ru.hashIncr("total_num_slow5", count5);
            }
            ru.hashVal("slowest");
            ru.hashVal("fastest");
        } else {
            ru.hashIncr("total_time", timespan);
            ru.hashIncr("total_num", count);
            if (timespan > 1000L) {
                ru.hashIncr("total_num_slow1", count1);
            }
            if (timespan > 2000L) {
                ru.hashIncr("total_num_slow2", count2);
            }
            if (timespan > 5000L) {
                ru.hashIncr("total_num_slow5", count5);
            }
            long slowest = ru.hashVal("slowest");
            long fastest = ru.hashVal("fastest");
            if (timespan > slowest) {
                ru.hashSet("slowest", timespan);
            }
            if (timespan < fastest || fastest == 0L) {
                ru.hashSet("fastest", timespan);
            }
        }
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        if (interval >= this.interval_min) {
            this.interval = interval;
        }
    }

    @Override
    public final void exec() throws Throwable {
        if (this._mainSet.size() == 0) {
            return;
        }
        this.flush(this._mainSet, this._serviceSet, this._fromSet);
    }

    protected abstract void flush(Map<String, TrackEvent> var1, Map<String, TrackEvent> var2, Map<String, TrackEvent> var3) throws Throwable;
}

