/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.model;

import java.util.Properties;
import javax.sql.DataSource;
import org.noear.esearchx.EsContext;
import org.noear.mongox.MgContext;
import org.noear.redisx.RedisClient;
import org.noear.snack.ONode;
import org.noear.water.WaterProps;
import org.noear.water.model.PropertiesM;
import org.noear.water.utils.CacheUtils;
import org.noear.water.utils.ConfigResolver;
import org.noear.water.utils.ConfigUtils;
import org.noear.water.utils.DsUtils;
import org.noear.water.utils.TextUtils;
import org.noear.wood.DbContext;
import org.noear.wood.cache.ICacheServiceEx;
import org.noear.wood.cache.LocalCache;
import org.noear.wood.cache.SecondCache;

public final class ConfigM {
    public final String key;
    public final long lastModified;
    public final String value;
    private PropertiesM _prop;
    private ONode _node;

    public ConfigM() {
        this.key = null;
        this.lastModified = 0L;
        this.value = null;
    }

    public ConfigM(String key, String value, long lastModified) {
        this.key = key;
        this.value = value;
        this.lastModified = lastModified;
    }

    public String getString() {
        return this.value;
    }

    public String getString(String def) {
        return this.value == null ? def : this.value;
    }

    public int getInt(int def) {
        if (TextUtils.isEmpty(this.value)) {
            return def;
        }
        return Integer.parseInt(this.value);
    }

    public int getInt() {
        return this.getInt(0);
    }

    public long getLong(long def) {
        if (TextUtils.isEmpty(this.value)) {
            return def;
        }
        return Long.parseLong(this.value);
    }

    public long getLong() {
        return this.getLong(0L);
    }

    public PropertiesM getProp() {
        if (this._prop == null) {
            this._prop = ConfigUtils.global.getProp(this.value);
        }
        return this._prop;
    }

    public ONode getNode() {
        if (this._node == null) {
            this._node = ConfigUtils.global.getNode(this.value);
        }
        return this._node;
    }

    public <T> T getObject(Class<T> clz) {
        if (TextUtils.isEmpty(this.value)) {
            return null;
        }
        if (this.value.trim().startsWith("{")) {
            return (T)this.getNode().toObject(clz);
        }
        return this.getProp().toObject(clz);
    }

    public EsContext getEs() {
        if (TextUtils.isEmpty(this.value)) {
            return null;
        }
        return new EsContext((Properties)this.getProp());
    }

    public RedisClient getRd() {
        return ConfigResolver.toRedis(this, 0);
    }

    public RedisClient getRd(int db) {
        return ConfigResolver.toRedis(this, db);
    }

    @Deprecated
    public RedisClient getRd(int db, int maxTotaol) {
        return this.getRd(db);
    }

    public MgContext getMg() {
        if (TextUtils.isEmpty(this.value)) {
            return null;
        }
        PropertiesM prop = this.getProp();
        String db = prop.getProperty("db");
        if (TextUtils.isEmpty(db)) {
            throw new IllegalArgumentException("Missing db configuration");
        }
        return ConfigResolver.toMongo(this, db);
    }

    public MgContext getMg(String db) {
        if (TextUtils.isEmpty(this.value)) {
            return null;
        }
        return ConfigResolver.toMongo(this, db);
    }

    public ICacheServiceEx getCh(String keyHeader, int defSeconds) {
        if (TextUtils.isEmpty(this.value)) {
            return new LocalCache(keyHeader, defSeconds);
        }
        return CacheUtils.getCh(this.getProp(), keyHeader, defSeconds);
    }

    public ICacheServiceEx getCh() {
        String name = WaterProps.service_name();
        if (TextUtils.isEmpty(name)) {
            throw new RuntimeException("System.getProperty(\"water.service.name\") is null, please configure!");
        }
        return this.getCh(name, 300);
    }

    public ICacheServiceEx getCh2(String keyHeader, int defSeconds) {
        LocalCache cache1 = new LocalCache(defSeconds);
        ICacheServiceEx cache2 = this.getCh(keyHeader, defSeconds);
        return new SecondCache((ICacheServiceEx)cache1, cache2);
    }

    public ICacheServiceEx getCh2() {
        String name = WaterProps.service_name();
        if (TextUtils.isEmpty(name)) {
            throw new RuntimeException("System.getProperty(\"water.service.name\") is null, please configure!");
        }
        return this.getCh2(name, 300);
    }

    public DbContext getDb() {
        return this.getDb(false);
    }

    public DbContext getDb(boolean pool) {
        return ConfigResolver.toDb(this, pool);
    }

    public DataSource getDs(boolean pool) {
        return DsUtils.getDs(this.getProp(), pool);
    }
}

