/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.staticfiles.repository;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.noear.solon.Solon;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.web.staticfiles.StaticRepository;

public class ClassPathStaticRepository
implements StaticRepository {
    String location;
    String locationDebug;
    ClassLoader classLoader;

    public ClassPathStaticRepository(String location) {
        this((ClassLoader)AppClassLoader.global(), location);
    }

    public ClassPathStaticRepository(ClassLoader classLoader, String location) {
        this.classLoader = classLoader;
        this.setLocation(location);
    }

    protected void setLocation(String location) {
        String rootdir;
        URL rooturi;
        if (location == null) {
            return;
        }
        if (location.startsWith("/")) {
            location = location.substring(1);
        }
        if (!location.endsWith("/")) {
            location = location + "/";
        }
        this.location = location;
        if (Solon.cfg().isDebugMode() && (rooturi = ResourceUtil.getResource((ClassLoader)this.classLoader, (String)"/")) != null && (rootdir = rooturi.toString().replace("target/classes/", "")).startsWith("file:")) {
            this.locationDebug = rootdir + "src/main/resources/" + location;
        }
    }

    @Override
    public URL find(String relativePath) throws Exception {
        URI uri;
        File file;
        if (this.locationDebug != null && (file = new File(uri = URI.create(this.locationDebug + relativePath))).exists()) {
            return uri.toURL();
        }
        return ResourceUtil.getResource((ClassLoader)this.classLoader, (String)(this.location + relativePath));
    }
}

