/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.staticfiles;

import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.noear.solon.Utils;
import org.noear.solon.boot.prop.GzipProps;
import org.noear.solon.boot.web.OutputUtils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.web.staticfiles.StaticConfig;
import org.noear.solon.web.staticfiles.StaticMappings;
import org.noear.solon.web.staticfiles.StaticMimes;

public class StaticResourceHandler
implements Handler {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final Date modified_time = new Date();

    public void handle(Context ctx) throws Exception {
        if (ctx.getHandled()) {
            return;
        }
        if (!MethodType.GET.name.equals(ctx.method())) {
            return;
        }
        String path = ctx.pathNew();
        String suffix = this.findByExtName(path);
        if (Utils.isEmpty((String)suffix)) {
            return;
        }
        String conentType = StaticMimes.findByExt(suffix);
        if (Utils.isEmpty((String)conentType)) {
            conentType = Utils.mime((String)suffix);
        }
        if (Utils.isEmpty((String)conentType)) {
            return;
        }
        URL resUri = null;
        String resUriZiped = null;
        String acceptEncoding = ctx.headerOrDefault("Accept-Encoding", "");
        if (GzipProps.hasMime((String)conentType)) {
            if (acceptEncoding.contains("gzip") && (resUri = StaticMappings.find(path + ".gz")) != null) {
                resUriZiped = "gzip";
            }
            if (resUri == null && acceptEncoding.contains("br") && (resUri = StaticMappings.find(path + ".br")) != null) {
                resUriZiped = "br";
            }
        }
        if (resUri == null) {
            resUri = StaticMappings.find(path);
        }
        if (resUri != null) {
            ctx.setHandled(true);
            String modified_since = ctx.header("If-Modified-Since");
            String modified_now = modified_time.toString();
            if (modified_since != null && StaticConfig.getCacheMaxAge() > 0 && modified_since.equals(modified_now)) {
                ctx.headerSet(CACHE_CONTROL, "max-age=" + StaticConfig.getCacheMaxAge());
                ctx.headerSet(LAST_MODIFIED, modified_now);
                ctx.status(304);
                return;
            }
            if (StaticConfig.getCacheMaxAge() > 0) {
                ctx.headerSet(CACHE_CONTROL, "max-age=" + StaticConfig.getCacheMaxAge());
                ctx.headerSet(LAST_MODIFIED, modified_time.toString());
            }
            if ("br".equals(resUriZiped) && acceptEncoding.contains("br")) {
                try (InputStream stream = resUri.openStream();){
                    ctx.contentType(conentType);
                    ctx.headerSet("Vary", "Accept-Encoding");
                    ctx.headerSet("Content-Encoding", "br");
                    OutputUtils.global().outputStreamAsRange(ctx, stream, (long)stream.available());
                }
                return;
            }
            if ("gzip".equals(resUriZiped) && acceptEncoding.contains("gzip")) {
                try (InputStream stream = resUri.openStream();){
                    ctx.contentType(conentType);
                    ctx.headerSet("Vary", "Accept-Encoding");
                    ctx.headerSet("Content-Encoding", "gzip");
                    OutputUtils.global().outputStreamAsRange(ctx, stream, (long)stream.available());
                }
                return;
            }
            OutputUtils.global().outputFile(ctx, resUri, conentType, StaticConfig.getCacheMaxAge() >= 0);
        }
    }

    private String findByExtName(String path) {
        int pos = path.lastIndexOf(35);
        if (pos > 0) {
            path = path.substring(0, pos - 1);
        }
        pos = path.lastIndexOf(46);
        pos = Math.max(pos, path.lastIndexOf(47));
        if ((pos = Math.max(pos, path.lastIndexOf(63))) != -1 && path.charAt(pos) == '.') {
            return path.substring(pos).toLowerCase();
        }
        return null;
    }
}

