/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd.protocol;

import java.nio.ByteBuffer;
import org.noear.solon.core.message.Message;
import org.noear.solon.socketd.protocol.MessageProtocol;

public class MessageProtocolBase
implements MessageProtocol {
    public static final MessageProtocol instance = new MessageProtocolBase();

    @Override
    public ByteBuffer encode(Message message) throws Exception {
        if (message.flag() == 1) {
            int len = message.body().length + 4 + 4;
            ByteBuffer buffer = ByteBuffer.allocate(len);
            buffer.putInt(len);
            buffer.putInt(message.flag());
            buffer.put(message.body());
            buffer.flip();
            return buffer;
        }
        byte[] keyB = message.key().getBytes(message.getCharset());
        byte[] resourceDescriptorB = message.resourceDescriptor().getBytes(message.getCharset());
        byte[] headerB = message.header().getBytes(message.getCharset());
        int len = keyB.length + resourceDescriptorB.length + headerB.length + message.body().length + 6 + 4 + 4;
        ByteBuffer buffer = ByteBuffer.allocate(len);
        buffer.putInt(len);
        buffer.putInt(message.flag());
        buffer.put(keyB);
        buffer.putChar('\n');
        buffer.put(resourceDescriptorB);
        buffer.putChar('\n');
        buffer.put(headerB);
        buffer.putChar('\n');
        buffer.put(message.body());
        buffer.flip();
        return buffer;
    }

    @Override
    public Message decode(ByteBuffer buffer) throws Exception {
        int len0 = buffer.getInt();
        if (len0 > buffer.remaining() + 4) {
            return null;
        }
        int flag = buffer.getInt();
        if (flag == 1) {
            int len = len0 - buffer.position();
            byte[] body = new byte[len];
            if (len > 0) {
                buffer.get(body, 0, len);
            }
            return new Message(flag, null, null, null, body);
        }
        ByteBuffer sb = ByteBuffer.allocate(Math.min(4096, buffer.limit()));
        String key = this.decodeString(buffer, sb, 256);
        if (key == null) {
            return null;
        }
        String resourceDescriptor = this.decodeString(buffer, sb, 512);
        if (resourceDescriptor == null) {
            return null;
        }
        String header = this.decodeString(buffer, sb, 0);
        if (header == null) {
            return null;
        }
        int len = len0 - buffer.position();
        byte[] body = new byte[len];
        if (len > 0) {
            buffer.get(body, 0, len);
        }
        return new Message(flag, key, resourceDescriptor, header, body);
    }

    protected String decodeString(ByteBuffer buffer, ByteBuffer sb, int maxLen) {
        byte c;
        sb.clear();
        while ((c = buffer.get()) != 10) {
            if (c != 0) {
                sb.put(c);
            }
            if (maxLen <= 0 || maxLen >= sb.position()) continue;
            return null;
        }
        sb.flip();
        if (sb.limit() < 1) {
            return "";
        }
        return new String(sb.array(), 0, sb.limit());
    }
}

