/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.noear.solon.Solon;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.RequestManager;
import org.noear.solon.socketd.SocketContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterListener
implements Listener {
    static final Logger log = LoggerFactory.getLogger(RouterListener.class);
    static final ExecutorService executor = Executors.newCachedThreadPool();

    public void onOpen(Session session) {
        executor.execute(() -> this.onOpen0(session));
    }

    private void onOpen0(Session session) {
        try {
            Listener sl = this.get(session);
            if (sl != null) {
                sl.onOpen(session);
            }
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
        }
    }

    public void onMessage(Session session, Message message) throws IOException {
        if (message == null) {
            return;
        }
        executor.execute(() -> this.onMessage0(session, message));
    }

    private void onMessage0(Session session, Message message) {
        block7: {
            try {
                CompletableFuture<Message> request;
                log.trace("Listener proxy receive: {}", (Object)message);
                Listener sl = this.get(session);
                if (sl != null) {
                    sl.onMessage(session, message);
                }
                if (session.listener() != null) {
                    session.listener().onMessage(session, message);
                }
                if (message.flag() == 11) {
                    return;
                }
                if (message.flag() == 13 && (request = RequestManager.get(message.key())) != null) {
                    RequestManager.remove(message.key());
                    request.complete(message);
                    return;
                }
                if (!message.getHandled()) {
                    SocketContextHandler.instance.handle(session, message);
                }
            }
            catch (Throwable e) {
                if (this.onError0(session, e)) break block7;
                EventBus.pushTry((Object)e);
            }
        }
    }

    public void onClose(Session session) {
        executor.execute(() -> this.onClose0(session));
    }

    private void onClose0(Session session) {
        try {
            Listener sl = this.get(session);
            if (sl != null) {
                sl.onClose(session);
            }
            if (session.listener() != null) {
                session.listener().onClose(session);
            }
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
        }
    }

    public void onError(Session session, Throwable error) {
        executor.execute(() -> this.onError0(session, error));
    }

    private boolean onError0(Session session, Throwable error) {
        try {
            boolean handled = false;
            Listener sl = this.get(session);
            if (sl != null) {
                handled = true;
                sl.onError(session, error);
            }
            if (session.listener() != null) {
                handled = true;
                session.listener().onError(session, error);
            }
            return handled;
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
            return true;
        }
    }

    private Listener get(Session s) {
        return Solon.app().router().matchOne(s);
    }
}

