/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.noear.solon.Solon;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.proxy.aot.AotProxy;
import org.noear.solon.proxy.asm.AsmProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(BeanInvocationHandler.class);
    private final BeanWrap bw;
    private final Object bean;
    private final InvocationHandler handler;
    private Object proxy;

    public BeanInvocationHandler(InvocationHandler handler, BeanWrap bw, Object bean) {
        this.bw = bw;
        this.bean = bean;
        this.handler = handler;
        if (NativeDetector.isNotAotRuntime()) {
            this.proxy = AotProxy.newProxyInstance(bw.context(), this, bw.rawClz(), bw.clzCtorArgs());
        }
        if (this.proxy == null) {
            this.proxy = AsmProxy.newProxyInstance(bw.context(), this, bw.rawClz(), bw.clzCtor(), bw.clzCtorArgs());
        }
        if (Solon.cfg().isDebugMode() && this.proxy != null) {
            log.trace("Proxy class:" + this.proxy.getClass().getName());
        }
    }

    public Object getProxy() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.handler == null) {
            ClassUtil.accessibleAsTrue((AccessibleObject)method);
            Object result = this.bw.context().methodGet(this.bw.rawClz(), method).invokeByAspect(this.bean, args);
            return result;
        }
        return this.handler.invoke(this.bean, method, args);
    }
}

