/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.noear.solon.maven.plugin.ClassesMove;
import org.noear.solon.maven.plugin.CopyLoader;
import org.noear.solon.maven.plugin.PluginType;
import org.noear.solon.maven.plugin.Repackager;
import org.noear.solon.maven.plugin.filter.Exclude;
import org.noear.solon.maven.plugin.filter.ExcludeFilter;
import org.noear.solon.maven.plugin.filter.Include;
import org.noear.solon.maven.plugin.filter.IncludeFilter;
import org.noear.solon.maven.plugin.filter.MatchingGroupIdFilter;
import org.noear.solon.maven.plugin.tools.tool.ArtifactsLibraries;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RepackageMojo
extends AbstractMojo {
    @Parameter(required=false)
    private String mainClass;
    @Parameter(readonly=false)
    private String jvmArguments;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.packaging}", required=true)
    private String packaging;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="true")
    public boolean includeSystemScope;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="solon.includes")
    private List<Include> includes;
    @Parameter(property="solon.excludes")
    private List<Exclude> excludes;
    @Parameter(property="solon.excludeGroupIds", defaultValue="")
    private String excludeGroupIds;
    public static PluginType PLUGIN_TYPE;
    private final Log logger = this.getLog();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logger.info((CharSequence)("Packaging type: " + this.packaging));
        if (this.packaging != null) {
            if ("jar".equalsIgnoreCase(this.packaging)) {
                PLUGIN_TYPE = PluginType.JAR;
                if (ClassesMove.isNotChangeJar(this.project.getArtifact().getFile())) {
                    this.logger.info((CharSequence)"Jar File No Change !!!");
                    return;
                }
                ClassesMove.change(this.project.getArtifact().getFile());
                this.repackage();
                try {
                    CopyLoader.start(this.getTargetFile());
                }
                catch (Exception e) {
                    throw new MojoExecutionException("write loader exception", e);
                }
            } else if ("war".equalsIgnoreCase(this.packaging)) {
                PLUGIN_TYPE = PluginType.WAR;
            }
        } else {
            throw new MojoExecutionException("The packaging is not of the JAR or WAR type");
        }
    }

    private void repackage() throws MojoExecutionException, MojoFailureException {
        try {
            File sourceFile = this.project.getArtifact().getFile();
            Repackager repackager = new Repackager(sourceFile, this.logger, this.mainClass);
            File target = this.getTargetFile();
            Set artifacts = this.project.getArtifacts();
            Set<Artifact> includedArtifacts = this.filterDependencies(artifacts, this.getAdditionalFilters());
            ArtifactsLibraries libraries = new ArtifactsLibraries(includedArtifacts, Collections.emptyList(), this.getLog());
            repackager.repackage(target, libraries);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private ArtifactsFilter[] getAdditionalFilters() {
        ArrayList<ScopeFilter> filters = new ArrayList<ScopeFilter>();
        if (!this.includeSystemScope) {
            filters.add(new ScopeFilter(null, "system"));
        }
        filters.add(new ScopeFilter(null, "provided"));
        return filters.toArray(new ArtifactsFilter[0]);
    }

    protected final Set<Artifact> filterDependencies(Set<Artifact> dependencies, ArtifactsFilter ... additionalFilters) throws MojoExecutionException {
        try {
            LinkedHashSet<Artifact> filtered = new LinkedHashSet<Artifact>(dependencies);
            filtered.retainAll(this.getFilters(additionalFilters).filter(dependencies));
            return filtered;
        }
        catch (ArtifactFilterException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private FilterArtifacts getFilters(ArtifactsFilter ... additionalFilters) {
        FilterArtifacts filters = new FilterArtifacts();
        for (ArtifactsFilter additionalFilter : additionalFilters) {
            filters.addFilter(additionalFilter);
        }
        filters.addFilter((ArtifactsFilter)new MatchingGroupIdFilter(this.cleanFilterConfig(this.excludeGroupIds)));
        if (this.includes != null && !this.includes.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new IncludeFilter(this.includes));
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new ExcludeFilter(this.excludes));
        }
        return filters;
    }

    private String cleanFilterConfig(String content) {
        if (content == null || content.trim().isEmpty()) {
            return "";
        }
        StringBuilder cleaned = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(content, ",");
        while (tokenizer.hasMoreElements()) {
            cleaned.append(tokenizer.nextToken().trim());
            if (!tokenizer.hasMoreElements()) continue;
            cleaned.append(",");
        }
        return cleaned.toString();
    }

    private File getTargetFile() {
        String classifier;
        String string = classifier = this.classifier != null ? this.classifier.trim() : "";
        if (classifier.length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        String name = this.finalName + classifier + "." + this.project.getArtifact().getArtifactHandler().getExtension();
        return new File(this.outputDirectory, name);
    }
}

