/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.predicate;

import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;

public class HeaderPredicateFactory
implements RoutePredicateFactory {
    @Override
    public String prefix() {
        return "Header";
    }

    @Override
    public ExPredicate create(String config) {
        return new HeaderPredicate(config);
    }

    private static class HeaderPredicate
    implements ExPredicate {
        private String headerName;
        private Pattern pattern;

        public HeaderPredicate(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("HeaderPredicate config cannot be blank");
            }
            String[] parts = config.split(",");
            if (parts.length == 0) {
                throw new IllegalArgumentException("HeaderPredicate config is wrong: " + config);
            }
            this.headerName = parts[0].trim();
            if (Utils.isEmpty((String)this.headerName)) {
                throw new IllegalArgumentException("Header name cannot be empty.");
            }
            if (parts.length > 1) {
                String regex = parts[1].trim();
                if (Utils.isEmpty((String)regex)) {
                    throw new IllegalArgumentException("Header regex cannot be empty.");
                }
                this.pattern = Pattern.compile(regex);
            }
        }

        @Override
        public boolean test(ExContext exContext) {
            String value = exContext.rawHeader(this.headerName);
            if (value == null) {
                return false;
            }
            if (this.pattern == null) {
                return true;
            }
            return this.pattern.matcher(value).find();
        }
    }
}

