/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.predicate;

import java.time.ZonedDateTime;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;

public class BeforePredicateFactory
implements RoutePredicateFactory {
    @Override
    public String prefix() {
        return "Before";
    }

    @Override
    public ExPredicate create(String config) {
        return new BeforePredicate(config);
    }

    public static class BeforePredicate
    implements ExPredicate {
        private final ZonedDateTime dateTime;

        public BeforePredicate(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("BeforePredicate config cannot be blank");
            }
            this.dateTime = ZonedDateTime.parse(config);
        }

        @Override
        public boolean test(ExContext ctx) {
            return ZonedDateTime.now().isBefore(this.dateTime);
        }
    }
}

