/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.filter;

import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExFilterChain;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import org.noear.solon.rx.Completable;

public class RedirectToFilterFactory
implements RouteFilterFactory {
    @Override
    public String prefix() {
        return "RedirectTo";
    }

    @Override
    public ExFilter create(String config) {
        return new RedirectToFilter(config);
    }

    public static class RedirectToFilter
    implements ExFilter {
        private int code;
        private String url;
        private boolean addQuery = false;

        public RedirectToFilter(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("RedirectToFilter config cannot be blank");
            }
            String[] parts = config.split(",");
            if (parts.length < 2) {
                throw new IllegalArgumentException("RedirectToFilter config is wrong: " + config);
            }
            this.code = Integer.parseInt(parts[0]);
            this.url = parts[1];
            if (parts.length > 2) {
                this.addQuery = Boolean.parseBoolean(parts[2]);
            }
        }

        @Override
        public Completable doFilter(ExContext ctx, ExFilterChain chain) {
            if (this.addQuery) {
                ctx.newResponse().redirect(this.code, this.url + ctx.rawQueryString());
            } else {
                ctx.newResponse().redirect(this.code, this.url);
            }
            return Completable.complete();
        }
    }
}

