/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.prop.GzipProps;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.util.DateUtil;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.RunUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputUtils {
    static final Logger log = LoggerFactory.getLogger(OutputUtils.class);
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static OutputUtils global = new OutputUtils();

    public static OutputUtils global() {
        return global;
    }

    public static void globalSet(OutputUtils instance) {
        if (instance != null) {
            global = instance;
        }
    }

    public void outputFile(Context ctx, DownloadedFile file, boolean asAttachment) throws IOException {
        if (Utils.isNotEmpty((String)file.getContentType())) {
            ctx.contentType(file.getContentType());
        }
        if (Utils.isNotEmpty((String)file.getETag())) {
            ctx.headerSet("ETag", file.getETag());
        }
        if (file.getMaxAgeSeconds() > 0) {
            String modified_since = ctx.header("If-Modified-Since");
            String modified_now = DateUtil.toGmtString((Date)file.getLastModified());
            if (modified_since != null && modified_since.equals(modified_now)) {
                RunUtil.runAndTry(() -> ((DownloadedFile)file).close());
                ctx.headerSet(CACHE_CONTROL, "max-age=" + file.getMaxAgeSeconds());
                ctx.headerSet(LAST_MODIFIED, modified_now);
                ctx.status(304);
                return;
            }
            ctx.headerSet(CACHE_CONTROL, "max-age=" + file.getMaxAgeSeconds());
            ctx.headerSet(LAST_MODIFIED, modified_now);
        }
        if (Utils.isNotEmpty((String)file.getName())) {
            String fileName = URLEncoder.encode(file.getName(), Solon.encoding());
            if (asAttachment) {
                ctx.headerSet("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            } else {
                ctx.headerSet("Content-Disposition", "filename=\"" + fileName + "\"");
            }
        }
        try (InputStream ins = file.getContent();){
            this.outputStream(ctx, ins, file.getContentSize(), file.getContentType());
        }
    }

    public void outputFile(Context ctx, File file, boolean asAttachment) throws IOException {
        String contentType;
        if (Utils.isNotEmpty((String)file.getName())) {
            String fileName = URLEncoder.encode(file.getName(), Solon.encoding());
            if (asAttachment) {
                ctx.headerSet("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            } else {
                ctx.headerSet("Content-Disposition", "filename=\"" + fileName + "\"");
            }
        }
        if (Utils.isNotEmpty((String)(contentType = Utils.mime((String)file.getName())))) {
            ctx.contentType(contentType);
        }
        try (FileInputStream ins = new FileInputStream(file);){
            this.outputStream(ctx, ins, file.length(), contentType);
        }
    }

    public void outputFile(Context ctx, URL file, String conentType, boolean useCaches) throws IOException {
        if (useCaches) {
            try (InputStream stream = file.openStream();){
                ctx.contentType(conentType);
                this.outputStream(ctx, stream, stream.available(), conentType);
            }
        }
        URLConnection connection = file.openConnection();
        connection.setUseCaches(false);
        try (InputStream stream = connection.getInputStream();){
            ctx.contentType(conentType);
            this.outputStream(ctx, stream, stream.available(), conentType);
        }
    }

    public void outputStream(Context ctx, InputStream stream, long streamSize, String mime) throws IOException {
        if (GzipProps.requiredGzip(ctx, mime, streamSize)) {
            this.outputStreamAsGzip(ctx, stream);
        } else {
            this.outputStreamAsRange(ctx, stream, streamSize);
        }
    }

    public void outputStreamAsGzip(Context ctx, InputStream stream) throws IOException {
        GZIPOutputStream gzipOut = ctx.outputStreamAsGzip();
        IoUtil.transferTo((InputStream)stream, (OutputStream)gzipOut);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void outputStreamAsRange(Context ctx, InputStream stream, long streamSize) throws IOException {
        if (streamSize <= 0L) {
            ctx.status(200);
            ctx.output(stream);
            return;
        }
        ctx.headerSet("Accept-Ranges", "bytes");
        if ("HEAD".equals(ctx.method())) {
            ctx.contentLength(streamSize);
            ctx.status(200);
            return;
        }
        String range = ctx.header("Range");
        long start = 0L;
        long end = 0L;
        long size = 0L;
        if (Utils.isEmpty((String)range)) {
            ctx.contentLength(streamSize);
            ctx.status(200);
            ctx.output(stream);
            return;
        }
        String[] ss1 = range.split("=");
        if (ss1.length != 2) {
            ctx.status(416);
            return;
        }
        String unit = ss1[0];
        String[] ss2 = ss1[1].split("-");
        if (!"bytes".equals(unit)) {
            ctx.status(416);
            return;
        }
        if (ss2.length == 2) {
            start = this.getLong(ss2[0]);
            end = this.getLong(ss2[1]);
        } else {
            if (ss2.length != 1) {
                ctx.status(416);
                return;
            }
            start = this.getLong(ss2[0]);
            end = streamSize - 1L;
        }
        if (end > 0L) {
            size = end - start + 1L;
        } else {
            end = streamSize - 1L;
            size = end - start + 1L;
        }
        if (end < 1L || size < 0L) {
            ctx.status(416);
            return;
        }
        if (size > streamSize - start) {
            ctx.status(416);
            return;
        }
        ctx.contentLength(size);
        ctx.status(206);
        ctx.headerSet("Connection", "keep-alive");
        ctx.headerSet("Content-Range", "bytes " + start + "-" + end + "/" + streamSize);
        try {
            IoUtil.transferTo((InputStream)stream, (OutputStream)ctx.outputStream(), (long)start, (long)size);
            return;
        }
        catch (IOException e) {
            log.debug("The http range output is abnormal: " + e.getMessage());
        }
    }

    protected long getLong(String str) {
        if (Utils.isEmpty((String)str)) {
            return 0L;
        }
        return Long.parseLong(str);
    }
}

