/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SslContextBuilder {
    private SecureRandom secureRandom = null;
    private KeyManager[] keyManagers = null;
    private TrustManager[] trustManagers = null;

    public SslContextBuilder secureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public SslContextBuilder keyManager(String keyStoreFile, String keyStorePassword) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        return this.keyManager(keyStoreFile, null, keyStorePassword);
    }

    public SslContextBuilder keyManager(String keyStoreFile, String type, String keyStorePassword) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        try (FileInputStream inputStream = new FileInputStream(keyStoreFile);){
            SslContextBuilder sslContextBuilder = this.keyManager(inputStream, type, keyStorePassword);
            return sslContextBuilder;
        }
    }

    public SslContextBuilder keyManager(InputStream keyStore, String keyStorePassword) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        return this.keyManager(keyStore, null, keyStorePassword);
    }

    public SslContextBuilder keyManager(InputStream keyStore, String type, String keyStorePassword) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        if (type == null) {
            type = "PKCS12";
        }
        KeyStore ks = this.loadKeyStore(keyStore, type, keyStorePassword.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyStorePassword.toCharArray());
        this.keyManagers = kmf.getKeyManagers();
        return this;
    }

    public SslContextBuilder trustManager(String trustStoreFile, String trustStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        return this.trustManager(trustStoreFile, null, trustStorePassword);
    }

    public SslContextBuilder trustManager(String trustStoreFile, String type, String trustStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (FileInputStream inputStream = new FileInputStream(trustStoreFile);){
            SslContextBuilder sslContextBuilder = this.trustManager(inputStream, type, trustStorePassword);
            return sslContextBuilder;
        }
    }

    public SslContextBuilder trustManager(InputStream trustStore, String trustStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        return this.trustManager(trustStore, null, trustStorePassword);
    }

    public SslContextBuilder trustManager(InputStream trustStore, String type, String trustStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (type == null) {
            type = "PKCS12";
        }
        KeyStore ts = this.loadKeyStore(trustStore, type, trustStorePassword.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        this.trustManagers = tmf.getTrustManagers();
        return this;
    }

    public SSLContext build() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(this.keyManagers, this.trustManagers, this.secureRandom);
        return sslContext;
    }

    private KeyStore loadKeyStore(InputStream inputStream, String type, char[] passphrase) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        KeyStore ks = KeyStore.getInstance(type);
        ks.load(inputStream, passphrase);
        return ks;
    }
}

