/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.socketd.transport.core.Constants;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.utils.StrUtils;

public class EntityDefault
implements Entity {
    private Map<String, String> metaMap;
    private String metaString = "";
    private boolean metaStringChanged = false;
    private ByteBuffer data = Constants.DEF_DATA;
    private int dataSize = 0;
    private String dataAsString;

    public EntityDefault at(String name) {
        this.metaPut("@", name);
        return this;
    }

    public EntityDefault range(int start, int size) {
        this.metaPut("Data-Range-Start", String.valueOf(start));
        this.metaPut("Data-Range-Size", String.valueOf(size));
        return this;
    }

    public EntityDefault metaStringSet(String metaString) {
        this.metaMap = null;
        this.metaString = metaString;
        this.metaStringChanged = false;
        return this;
    }

    @Override
    public String metaString() {
        if (this.metaStringChanged) {
            StringBuilder buf = new StringBuilder();
            ArrayList<String> metaKeys = new ArrayList<String>(this.metaMap().keySet());
            for (String name : metaKeys) {
                String val = this.metaMap().get(name);
                buf.append(name).append("=").append(val).append("&");
            }
            if (buf.length() > 0) {
                buf.setLength(buf.length() - 1);
            }
            this.metaString = buf.toString();
            this.metaStringChanged = false;
        }
        return this.metaString;
    }

    public EntityDefault metaMapPut(Map<String, String> metaMap) {
        if (metaMap != null && metaMap.size() > 0) {
            this.metaMap().putAll(metaMap);
            this.metaStringChanged = true;
        }
        return this;
    }

    @Override
    public Map<String, String> metaMap() {
        if (this.metaMap == null) {
            this.metaMap = new ConcurrentHashMap<String, String>();
            this.metaStringChanged = false;
            if (StrUtils.isNotEmpty(this.metaString)) {
                for (String kvStr : this.metaString.split("&")) {
                    int idx = kvStr.indexOf(61);
                    if (idx <= 0) continue;
                    this.metaMap.put(kvStr.substring(0, idx), kvStr.substring(idx + 1));
                }
            }
        }
        return this.metaMap;
    }

    public EntityDefault metaPut(String name, String val) {
        if (val == null) {
            this.metaMap().remove(name);
        } else {
            this.metaMap().put(name, val);
        }
        this.metaStringChanged = true;
        return this;
    }

    public EntityDefault metaDel(String name) {
        this.metaMap().remove(name);
        this.metaStringChanged = true;
        return this;
    }

    @Override
    public String meta(String name) {
        return this.metaMap().get(name);
    }

    @Override
    public String metaOrDefault(String name, String def) {
        return this.metaMap().getOrDefault(name, def);
    }

    @Override
    public void putMeta(String name, String val) {
        this.metaPut(name, val);
    }

    @Override
    public void delMeta(String name) {
        this.metaDel(name);
    }

    public EntityDefault dataSet(byte[] data) {
        this.data = ByteBuffer.wrap(data);
        this.dataSize = data.length;
        return this;
    }

    public EntityDefault dataSet(ByteBuffer data) {
        this.data = data;
        this.dataSize = data.limit();
        return this;
    }

    @Override
    public ByteBuffer data() {
        return this.data;
    }

    @Override
    public String dataAsString() {
        if (this.dataAsString == null) {
            this.dataAsString = new String(this.dataAsBytes(), StandardCharsets.UTF_8);
        }
        return this.dataAsString;
    }

    @Override
    public byte[] dataAsBytes() {
        if (this.data instanceof MappedByteBuffer) {
            byte[] tmp = new byte[this.dataSize];
            this.data.mark();
            this.data.get(tmp);
            this.data.reset();
            return tmp;
        }
        return this.data.array();
    }

    @Override
    public int dataSize() {
        return this.dataSize;
    }

    @Override
    public void release() throws IOException {
    }

    public String toString() {
        return "Entity{meta='" + this.metaString() + '\'' + ", data=byte[" + this.dataSize + ']' + '}';
    }
}

