/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.broker;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.socketd.cluster.LoadBalancer;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.utils.StrUtils;

public abstract class BrokerListenerBase {
    private Map<String, Session> sessionAll = new ConcurrentHashMap<String, Session>();
    private Map<String, Set<Session>> playerSessions = new ConcurrentHashMap<String, Set<Session>>();

    public Collection<Session> getSessionAll() {
        return this.sessionAll.values();
    }

    public Session getSessionById(String sessionId) {
        return this.sessionAll.get(sessionId);
    }

    public Session getSessionAny() {
        return LoadBalancer.getAnyByPoll(this.sessionAll.values());
    }

    public int getSessionCount() {
        return this.sessionAll.size();
    }

    public Collection<String> getNameAll() {
        return this.playerSessions.keySet();
    }

    public int getPlayerCount(String name) {
        Collection<Session> tmp = this.getPlayerAll(name);
        if (tmp == null) {
            return 0;
        }
        return tmp.size();
    }

    @Deprecated
    public int getPlayerNum(String name) {
        return this.getPlayerCount(name);
    }

    public Collection<Session> getPlayerAll(String name) {
        return this.playerSessions.get(name);
    }

    public Session getPlayerAny(String atName, Session requester, Message message) throws IOException {
        if (StrUtils.isEmpty(atName)) {
            return null;
        }
        if (atName.endsWith("!")) {
            atName = atName.substring(0, atName.length() - 1);
            String x_hash = null;
            if (message != null) {
                x_hash = message.meta("X-Hash");
            }
            if (StrUtils.isEmpty(x_hash)) {
                if (requester == null) {
                    return LoadBalancer.getAnyByPoll(this.getPlayerAll(atName));
                }
                return LoadBalancer.getAnyByHash(this.getPlayerAll(atName), requester.remoteAddress().getHostName());
            }
            return LoadBalancer.getAnyByHash(this.getPlayerAll(atName), x_hash);
        }
        return LoadBalancer.getAnyByPoll(this.getPlayerAll(atName));
    }

    public Session getPlayerAny(String atName) {
        if (StrUtils.isEmpty(atName)) {
            return null;
        }
        if (atName.endsWith("!")) {
            atName = atName.substring(0, atName.length() - 1);
        }
        return LoadBalancer.getAnyByPoll(this.getPlayerAll(atName));
    }

    @Deprecated
    public Session getPlayerOne(String atName) {
        return this.getPlayerAny(atName);
    }

    public void addPlayer(String name, Session session) {
        if (StrUtils.isNotEmpty(name)) {
            Set sessions = this.playerSessions.computeIfAbsent(name, n -> Collections.newSetFromMap(new ConcurrentHashMap()));
            sessions.add(session);
        }
        this.sessionAll.put(session.sessionId(), session);
    }

    public void removePlayer(String name, Session session) {
        Collection<Session> sessions;
        if (StrUtils.isNotEmpty(name) && (sessions = this.getPlayerAll(name)) != null) {
            sessions.remove(session);
        }
        this.sessionAll.remove(session.sessionId());
    }
}

