/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.Handshake;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.MessageInternal;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.entity.MessageBuilder;
import org.noear.socketd.transport.core.impl.SessionBase;
import org.noear.socketd.transport.stream.RequestStream;
import org.noear.socketd.transport.stream.SendStream;
import org.noear.socketd.transport.stream.SubscribeStream;
import org.noear.socketd.transport.stream.impl.RequestStreamImpl;
import org.noear.socketd.transport.stream.impl.SendStreamImpl;
import org.noear.socketd.transport.stream.impl.SubscribeStreamImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionDefault
extends SessionBase {
    private static final Logger log = LoggerFactory.getLogger(SessionDefault.class);
    private String pathNew;

    public SessionDefault(Channel channel) {
        super(channel);
    }

    @Override
    public boolean isValid() {
        return this.channel.isValid();
    }

    @Override
    public boolean isClosing() {
        return this.channel.isClosing();
    }

    @Override
    public InetSocketAddress remoteAddress() throws IOException {
        return this.channel.getRemoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() throws IOException {
        return this.channel.getLocalAddress();
    }

    @Override
    public Handshake handshake() {
        return this.channel.getHandshake();
    }

    @Override
    public String param(String name) {
        return this.handshake().param(name);
    }

    @Override
    public String paramOrDefault(String name, String def) {
        return this.handshake().paramOrDefault(name, def);
    }

    @Override
    public String path() {
        if (this.pathNew == null) {
            return this.handshake().path();
        }
        return this.pathNew;
    }

    @Override
    public void pathNew(String pathNew) {
        this.pathNew = pathNew;
    }

    @Override
    public void reconnect() throws IOException {
        this.channel.reconnect();
    }

    @Override
    public void sendPing() throws IOException {
        this.channel.sendPing();
    }

    @Override
    public void sendAlarm(Message from, String alarm) throws IOException {
        this.channel.sendAlarm(from, alarm);
    }

    @Override
    public SendStream send(String event, Entity entity) throws IOException {
        if (entity == null) {
            entity = new EntityDefault();
        }
        MessageInternal message = new MessageBuilder().sid(this.generateId()).event(event).entity(entity).build();
        SendStreamImpl stream = new SendStreamImpl(message.sid());
        this.channel.send(new Frame(40, message), stream);
        return stream;
    }

    @Override
    public RequestStream sendAndRequest(String event, Entity entity, long timeout) throws IOException {
        if (entity == null) {
            entity = new EntityDefault();
        }
        MessageInternal message = new MessageBuilder().sid(this.generateId()).event(event).entity(entity).build();
        if (timeout < 0L) {
            timeout = this.channel.getConfig().getStreamTimeout();
        }
        if (timeout == 0L) {
            timeout = this.channel.getConfig().getRequestTimeout();
        }
        RequestStreamImpl stream = new RequestStreamImpl(message.sid(), timeout);
        this.channel.send(new Frame(41, message), stream);
        return stream;
    }

    @Override
    public SubscribeStream sendAndSubscribe(String event, Entity entity, long timeout) throws IOException {
        if (entity == null) {
            entity = new EntityDefault();
        }
        MessageInternal message = new MessageBuilder().sid(this.generateId()).event(event).entity(entity).build();
        if (timeout <= 0L) {
            timeout = this.channel.getConfig().getStreamTimeout();
        }
        SubscribeStreamImpl stream = new SubscribeStreamImpl(message.sid(), timeout);
        this.channel.send(new Frame(42, message), stream);
        return stream;
    }

    @Override
    public void reply(Message from, Entity entity) throws IOException {
        if (entity == null) {
            entity = new EntityDefault();
        }
        MessageInternal message = new MessageBuilder().sid(from.sid()).event(from.event()).entity(entity).build();
        this.channel.send(new Frame(48, message), null);
    }

    @Override
    public void replyEnd(Message from, Entity entity) throws IOException {
        if (entity == null) {
            entity = new EntityDefault();
        }
        MessageInternal message = new MessageBuilder().sid(from.sid()).event(from.event()).entity(entity).build();
        this.channel.send(new Frame(49, message), null);
    }

    @Override
    public void preclose() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("{} session close starting, sessionId={}", (Object)this.channel.getConfig().getRoleName(), (Object)this.sessionId());
        }
        if (this.channel.isValid()) {
            this.channel.sendClose(1000);
        }
    }

    @Override
    public void close() throws IOException {
        block4: {
            if (log.isDebugEnabled()) {
                log.debug("{} session will be closed, sessionId={}", (Object)this.channel.getConfig().getRoleName(), (Object)this.sessionId());
            }
            if (this.channel.isValid()) {
                try {
                    this.channel.sendClose(1001);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("{} channel sendClose error", (Object)this.channel.getConfig().getRoleName(), (Object)e);
                }
            }
        }
        this.channel.close(2009);
    }
}

