/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.codec;

import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.CodecReader;

public class ByteBufferCodecReader
implements CodecReader {
    private ByteBuffer buffer;

    public ByteBufferCodecReader(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public byte getByte() {
        return this.buffer.get();
    }

    @Override
    public void getBytes(byte[] dst, int offset, int length) {
        this.buffer.get(dst, offset, length);
    }

    @Override
    public int getInt() {
        return this.buffer.getInt();
    }

    @Override
    public byte peekByte() {
        if (this.buffer.remaining() > 0) {
            return this.buffer.get(this.buffer.position());
        }
        return -1;
    }

    @Override
    public void skipBytes(int length) {
        this.buffer.position(this.buffer.position() + length);
    }

    @Override
    public int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public int position() {
        return this.buffer.position();
    }
}

