/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.noear.socketd.transport.client.ClientSession;

public class LoadBalancer {
    private static AtomicInteger roundCounter = new AtomicInteger(0);

    private static int roundCounterGet() {
        int counter = roundCounter.incrementAndGet();
        if (counter > 999999) {
            roundCounter.set(0);
        }
        return counter;
    }

    public static <T extends ClientSession> T getAnyByPoll(Collection<T> coll) {
        return LoadBalancer.getAny(coll, LoadBalancer::roundCounterGet);
    }

    public static <T extends ClientSession> T getAnyByHash(Collection<T> coll, String diversion) {
        return LoadBalancer.getAny(coll, diversion::hashCode);
    }

    public static <T extends ClientSession> T getAny(Collection<T> coll, Supplier<Integer> randomSupplier) {
        if (coll == null || coll.size() == 0) {
            return null;
        }
        ArrayList<ClientSession> sessions = new ArrayList<ClientSession>();
        for (ClientSession s : coll) {
            if (!s.isValid() || s.isClosing()) continue;
            sessions.add(s);
        }
        if (sessions.size() == 0) {
            return null;
        }
        if (sessions.size() == 1) {
            return (T)((ClientSession)sessions.get(0));
        }
        int random = Math.abs(randomSupplier.get());
        int idx = random % sessions.size();
        return (T)((ClientSession)sessions.get(idx));
    }

    public static <T extends ClientSession> T getFirst(Collection<T> coll) {
        if (coll == null || coll.size() == 0) {
            return null;
        }
        for (ClientSession s : coll) {
            if (!s.isValid() || s.isClosing()) continue;
            return (T)s;
        }
        return null;
    }
}

