/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.noear.socketd.cluster.LoadBalancer;
import org.noear.socketd.exception.SocketDException;
import org.noear.socketd.transport.client.ClientSession;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.stream.RequestStream;
import org.noear.socketd.transport.stream.SendStream;
import org.noear.socketd.transport.stream.SubscribeStream;
import org.noear.socketd.utils.RunUtils;
import org.noear.socketd.utils.StrUtils;

public class ClusterClientSession
implements ClientSession {
    private final List<ClientSession> sessionList;
    private final String sessionId;

    public ClusterClientSession(List<ClientSession> sessions) {
        this.sessionList = sessions;
        this.sessionId = StrUtils.guid();
    }

    public List<ClientSession> getSessionAll() {
        return Collections.unmodifiableList(this.sessionList);
    }

    public ClientSession getSessionAny(String diversionOrNull) {
        ClientSession session = null;
        session = StrUtils.isEmpty(diversionOrNull) ? LoadBalancer.getAnyByPoll(this.sessionList) : LoadBalancer.getAnyByHash(this.sessionList, diversionOrNull);
        if (session == null) {
            throw new SocketDException("No session is available!");
        }
        return session;
    }

    @Deprecated
    public ClientSession getSessionOne() {
        return this.getSessionAny(null);
    }

    @Override
    public boolean isValid() {
        for (ClientSession session : this.sessionList) {
            if (!session.isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isClosing() {
        for (ClientSession session : this.sessionList) {
            if (!session.isClosing()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    public SendStream send(String event, Entity entity) throws IOException {
        ClientSession sender = this.getSessionAny(null);
        return sender.send(event, entity);
    }

    @Override
    public RequestStream sendAndRequest(String event, Entity entity, long timeout) throws IOException {
        ClientSession sender = this.getSessionAny(null);
        return sender.sendAndRequest(event, entity, timeout);
    }

    @Override
    public SubscribeStream sendAndSubscribe(String event, Entity entity, long timeout) throws IOException {
        ClientSession sender = this.getSessionAny(null);
        return sender.sendAndSubscribe(event, entity, timeout);
    }

    @Override
    public void preclose() throws IOException {
        for (ClientSession session : this.sessionList) {
            RunUtils.runAndTry(session::preclose);
        }
    }

    @Override
    public void close() throws IOException {
        for (ClientSession session : this.sessionList) {
            RunUtils.runAndTry(session::close);
        }
    }

    @Override
    public void reconnect() throws IOException {
        for (ClientSession session : this.sessionList) {
            if (session.isValid()) continue;
            session.reconnect();
        }
    }
}

