/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.noear.socketd.SocketD;
import org.noear.socketd.cluster.ClusterClientSession;
import org.noear.socketd.transport.client.Client;
import org.noear.socketd.transport.client.ClientConfigHandler;
import org.noear.socketd.transport.client.ClientConnectHandler;
import org.noear.socketd.transport.client.ClientHeartbeatHandler;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.client.ClientSession;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.utils.StrUtils;

public class ClusterClient
implements Client {
    private final String[] serverUrls;
    private ClientConnectHandler connectHandler;
    private ClientHeartbeatHandler heartbeatHandler;
    private ClientConfigHandler configHandler;
    private Listener listener;

    public ClusterClient(String ... serverUrls) {
        this.serverUrls = serverUrls;
    }

    @Override
    public Client connectHandler(ClientConnectHandler connectHandler) {
        this.connectHandler = connectHandler;
        return this;
    }

    @Override
    public Client heartbeatHandler(ClientHeartbeatHandler heartbeatHandler) {
        this.heartbeatHandler = heartbeatHandler;
        return this;
    }

    @Override
    public Client config(ClientConfigHandler configHandler) {
        this.configHandler = configHandler;
        return this;
    }

    @Override
    public Client listen(Listener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public ClientSession open() {
        try {
            return this.openDo(false);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ClientSession openOrThow() throws IOException {
        return this.openDo(true);
    }

    private ClientSession openDo(boolean isThow) throws IOException {
        ArrayList<ClientSession> sessionList = new ArrayList<ClientSession>();
        ExecutorService exchangeExecutor = null;
        for (String urls : this.serverUrls) {
            for (String url : urls.split(",")) {
                if (StrUtils.isEmpty(url = url.trim())) continue;
                ClientInternal client = (ClientInternal)SocketD.createClient(url);
                if (this.listener != null) {
                    client.listen(this.listener);
                }
                if (this.configHandler != null) {
                    client.config(this.configHandler);
                }
                if (this.connectHandler != null) {
                    client.connectHandler(this.connectHandler);
                }
                if (this.heartbeatHandler != null) {
                    client.heartbeatHandler(this.heartbeatHandler);
                }
                if (exchangeExecutor == null) {
                    exchangeExecutor = client.getConfig().getExchangeExecutor();
                } else {
                    client.getConfig().exchangeExecutor(exchangeExecutor);
                }
                if (isThow) {
                    sessionList.add(client.openOrThow());
                    continue;
                }
                sessionList.add(client.open());
            }
        }
        return new ClusterClientSession(sessionList);
    }
}

