/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.noear.socketd.exception.SocketDConnectionException;
import org.noear.socketd.transport.client.ClientConnectorBase;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.java_udp.UdpBioChannelAssistant;
import org.noear.socketd.transport.java_udp.UdpBioClient;
import org.noear.socketd.transport.java_udp.impl.DatagramFrame;
import org.noear.socketd.transport.java_udp.impl.DatagramTagert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpBioClientConnector
extends ClientConnectorBase<UdpBioClient> {
    private static final Logger log = LoggerFactory.getLogger(UdpBioClientConnector.class);
    private DatagramSocket real;
    private Thread receiveThread;
    private Thread connectThread;

    public UdpBioClientConnector(UdpBioClient client) {
        super((ClientInternal)client);
    }

    public ChannelInternal connect() throws IOException {
        this.close();
        CompletableFuture handshakeFuture = new CompletableFuture();
        this.connectThread = new Thread(() -> {
            try {
                this.connectDo(handshakeFuture);
            }
            catch (Throwable e) {
                handshakeFuture.complete(new ClientHandshakeResult(null, e));
            }
        });
        this.connectThread.start();
        try {
            ClientHandshakeResult handshakeResult = (ClientHandshakeResult)handshakeFuture.get(((UdpBioClient)this.client).getConfig().getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (handshakeResult.getThrowable() != null) {
                throw handshakeResult.getThrowable();
            }
            return handshakeResult.getChannel();
        }
        catch (TimeoutException e) {
            this.close();
            throw new SocketDConnectionException("Connection timeout: " + ((UdpBioClient)this.client).getConfig().getLinkUrl());
        }
        catch (Throwable e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketDConnectionException("Connection failed: " + ((UdpBioClient)this.client).getConfig().getLinkUrl(), e);
        }
    }

    private void connectDo(CompletableFuture<ClientHandshakeResult> handshakeFuture) throws IOException {
        this.real = new DatagramSocket();
        InetSocketAddress socketAddress = new InetSocketAddress(((UdpBioClient)this.client).getConfig().getHost(), ((UdpBioClient)this.client).getConfig().getPort());
        this.real.connect(socketAddress);
        DatagramTagert tagert = new DatagramTagert(this.real, null, true);
        ChannelDefault channel = new ChannelDefault((Object)tagert, (ChannelSupporter)this.client);
        this.receiveThread = new Thread(() -> this.lambda$connectDo$1((ChannelInternal)channel, handshakeFuture));
        this.receiveThread.start();
        channel.sendConnect(((UdpBioClient)this.client).getConfig().getUrl(), ((UdpBioClient)this.client).getConfig().getMetaMap());
    }

    private void receive(ChannelInternal channel, DatagramSocket socket, CompletableFuture<ClientHandshakeResult> handshakeFuture) {
        while (!this.receiveThread.isInterrupted()) {
            try {
                if (socket.isClosed()) {
                    ((UdpBioClient)this.client).getProcessor().onClose(channel);
                    break;
                }
                DatagramFrame frame = ((UdpBioChannelAssistant)((UdpBioClient)this.client).getAssistant()).read(socket);
                if (frame == null) continue;
                if (frame.getFrame().flag() == 11) {
                    channel.onOpenFuture((r, e) -> handshakeFuture.complete(new ClientHandshakeResult(channel, e)));
                }
                ((UdpBioClient)this.client).getProcessor().reveFrame(channel, frame.getFrame());
            }
            catch (Exception e2) {
                if (e2 instanceof SocketDConnectionException) {
                    handshakeFuture.complete(new ClientHandshakeResult(channel, (Throwable)e2));
                    break;
                }
                ((UdpBioClient)this.client).getProcessor().onError(channel, (Throwable)e2);
                if (!(e2 instanceof SocketException)) continue;
                break;
            }
        }
    }

    public void close() {
        block5: {
            try {
                if (this.real != null) {
                    this.real.close();
                }
                if (this.receiveThread != null) {
                    this.receiveThread.interrupt();
                }
                if (this.connectThread != null) {
                    this.connectThread.interrupt();
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Client connector close error", e);
            }
        }
    }

    private /* synthetic */ void lambda$connectDo$1(ChannelInternal channel, CompletableFuture handshakeFuture) {
        try {
            this.receive(channel, this.real, handshakeFuture);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }
}

