/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.CodecReader;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.codec.ByteBufferCodecReader;
import org.noear.socketd.transport.core.codec.ByteBufferCodecWriter;
import org.noear.socketd.transport.java_udp.impl.DatagramFrame;
import org.noear.socketd.transport.java_udp.impl.DatagramTagert;
import org.noear.socketd.utils.IoCompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpBioChannelAssistant
implements ChannelAssistant<DatagramTagert> {
    private static final Logger log = LoggerFactory.getLogger(UdpBioChannelAssistant.class);
    private final Config config;

    public UdpBioChannelAssistant(Config config) {
        this.config = config;
    }

    public DatagramFrame read(DatagramSocket source) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(new byte[this.config.getMaxUdpSize()], this.config.getMaxUdpSize());
        source.receive(datagramPacket);
        if (datagramPacket.getLength() < 4) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(datagramPacket.getData(), 0, datagramPacket.getLength());
        buffer.mark();
        int frameSize = buffer.getInt();
        if (frameSize > datagramPacket.getLength()) {
            return null;
        }
        buffer.reset();
        Frame frame = this.config.getCodec().read((CodecReader)new ByteBufferCodecReader(buffer));
        return new DatagramFrame(datagramPacket, frame);
    }

    public void write(DatagramTagert target, Frame frame, ChannelInternal channel, IoCompletionHandler completionHandler) {
        try {
            ByteBufferCodecWriter writer = (ByteBufferCodecWriter)this.config.getCodec().write(frame, i -> new ByteBufferCodecWriter(ByteBuffer.allocate(i)));
            target.send(writer.getBuffer().array());
            completionHandler.completed(true, null);
        }
        catch (Throwable e) {
            completionHandler.completed(false, e);
        }
    }

    public boolean isValid(DatagramTagert target) {
        return true;
    }

    public void close(DatagramTagert target) throws IOException {
        target.close();
    }

    public InetSocketAddress getRemoteAddress(DatagramTagert target) throws IOException {
        return target.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress(DatagramTagert target) throws IOException {
        return target.getLocalAddress();
    }
}

