/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.utils;

import java.io.Reader;
import java.sql.Clob;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.snack.exception.SnackException;

public class BeanUtil {
    public static final Map<String, Class<?>> clzCached = new ConcurrentHashMap();

    public static Class<?> loadClass(String clzName) {
        try {
            Class<?> clz = clzCached.get(clzName);
            if (clz == null) {
                clz = Class.forName(clzName);
                clzCached.put(clzName, clz);
            }
            return clz;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SnackException(e);
        }
    }

    public static String clobToString(Clob clob) {
        Reader reader = null;
        StringBuilder buf = new StringBuilder();
        try {
            int len;
            reader = clob.getCharacterStream();
            char[] chars = new char[2048];
            while ((len = reader.read(chars, 0, chars.length)) >= 0) {
                buf.append(chars, 0, len);
            }
        }
        catch (Exception ex) {
            throw new SnackException("read string from reader error", ex);
        }
        String text = buf.toString();
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception ex) {
                throw new SnackException("read string from reader error", ex);
            }
        }
        return text;
    }

    public static Object newInstance(Class<?> clz) {
        try {
            return clz.newInstance();
        }
        catch (Exception ex) {
            throw new SnackException("create instance error, class " + clz.getName());
        }
    }
}

