/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.hpack;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.smartboot.http.common.codec.h2.hpack.Huffman;
import org.smartboot.http.common.codec.h2.hpack.ISO_8859_1;
import org.smartboot.http.common.codec.h2.hpack.IntegerReader;
import org.smartboot.http.common.codec.h2.hpack.QuickHuffman;

final class StringReader {
    private static final int NEW = 0;
    private static final int FIRST_BYTE_READ = 1;
    private static final int LENGTH_READ = 2;
    private static final int DONE = 4;
    private final IntegerReader intReader = new IntegerReader();
    private final Huffman.Reader huffmanReader = new QuickHuffman.Reader();
    private final ISO_8859_1.Reader plainReader = new ISO_8859_1.Reader();
    private int state = 0;
    private boolean huffman;
    private int remainingLength;

    StringReader() {
    }

    boolean read(ByteBuffer input, Appendable output) throws IOException {
        if (this.state == 4) {
            return true;
        }
        if (!input.hasRemaining()) {
            return false;
        }
        if (this.state == 0) {
            int p = input.position();
            this.huffman = (input.get(p) & 0x80) != 0;
            this.state = 1;
            this.intReader.configure(7);
        }
        if (this.state == 1) {
            boolean lengthRead = this.intReader.read(input);
            if (!lengthRead) {
                return false;
            }
            this.remainingLength = this.intReader.get();
            this.state = 2;
        }
        if (this.state == 2) {
            boolean isLast = input.remaining() >= this.remainingLength;
            int oldLimit = input.limit();
            if (isLast) {
                input.limit(input.position() + this.remainingLength);
            }
            this.remainingLength -= Math.min(input.remaining(), this.remainingLength);
            if (this.huffman) {
                this.huffmanReader.read(input, output, isLast);
            } else {
                this.plainReader.read(input, output);
            }
            if (isLast) {
                input.limit(oldLimit);
                this.state = 4;
            }
            return isLast;
        }
        throw new InternalError(Arrays.toString(new Object[]{this.state, this.huffman, this.remainingLength}));
    }

    boolean isHuffmanEncoded() {
        if (this.state < 1) {
            throw new IllegalStateException("Has not been fully read yet");
        }
        return this.huffman;
    }

    void reset() {
        if (this.huffman) {
            this.huffmanReader.reset();
        } else {
            this.plainReader.reset();
        }
        this.intReader.reset();
        this.state = 0;
    }
}

