/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common;

import java.io.File;
import org.smartboot.http.common.Part;
import org.smartboot.http.common.utils.FileReleaseTracker;

public class Multipart {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DASH = 45;
    public static final int HEADER_PART_SIZE_MAX = 10240;
    public static final int DEFAULT_BUF_SIZE = 4096;
    public static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    public static final byte[] FIELD_SEPARATOR = new byte[]{13, 10};
    public static final byte[] STREAM_TERMINATOR = new byte[]{45, 45};
    public static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private static final FileReleaseTracker fileCleaningTracker = new FileReleaseTracker();
    private int boundaryLength;
    private final byte[] boundary;
    private final byte[] separator;
    private int bufferPos = 0;
    private int bodyLength;
    private int separatorIndex;
    private int CRLFIndex;
    private boolean isMatch;

    public Multipart(byte[] boundary) {
        this.boundary = boundary;
        this.separator = ("--" + new String(boundary)).getBytes();
        this.boundaryLength = boundary.length;
    }

    public void addItemTracker(Part part) {
        File tempFile = part.getTempFile();
        if (tempFile != null) {
            fileCleaningTracker.track(tempFile, part);
        }
    }

    public void stopTacking() {
        fileCleaningTracker.stop();
    }

    public int getBoundaryLength() {
        return this.boundaryLength;
    }

    public void setBoundaryLength(int boundaryLength) {
        this.boundaryLength = boundaryLength;
    }

    public byte[] getBoundary() {
        return this.boundary;
    }

    public int getBufferPos() {
        return this.bufferPos;
    }

    public void setBufferPos(int bufferPos) {
        this.bufferPos = bufferPos;
    }

    public int getBodyLength() {
        return this.bodyLength;
    }

    public void setBodyLength(int bodyLength) {
        this.bodyLength = bodyLength;
    }

    public int getSeparatorIndex() {
        return this.separatorIndex;
    }

    public void setSeparatorIndex(int separatorIndex) {
        this.separatorIndex = separatorIndex;
    }

    public int getCRLFIndex() {
        return this.CRLFIndex;
    }

    public void setCRLFIndex(int CRLFIndex) {
        this.CRLFIndex = CRLFIndex;
    }

    public boolean isMatch() {
        return this.isMatch;
    }

    public void setMatch(boolean match) {
        this.isMatch = match;
    }

    public byte[] getSeparator() {
        return this.separator;
    }
}

