/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx;

import java.net.URI;
import java.time.Duration;
import java.util.HashSet;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.noear.redisx.RedisSession;
import org.noear.redisx.RedisSessionImpl;
import org.noear.redisx.Serializer;
import org.noear.redisx.plus.RedisAtomic;
import org.noear.redisx.plus.RedisBucket;
import org.noear.redisx.plus.RedisBus;
import org.noear.redisx.plus.RedisHash;
import org.noear.redisx.plus.RedisId;
import org.noear.redisx.plus.RedisList;
import org.noear.redisx.plus.RedisLock;
import org.noear.redisx.plus.RedisQueue;
import org.noear.redisx.utils.SerializerDefault;
import org.noear.redisx.utils.TextUtil;
import redis.clients.jedis.ConnectionPoolConfig;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.UnifiedJedis;

public class RedisClient
implements AutoCloseable {
    private UnifiedJedis unifiedJedis;
    private Serializer serializer = new SerializerDefault();

    public Serializer serializer() {
        return this.serializer;
    }

    public UnifiedJedis jedis() {
        return this.unifiedJedis;
    }

    public void serializer(Serializer serializer) {
        if (serializer != null) {
            this.serializer = serializer;
        }
    }

    public RedisClient(Properties prop) {
        String db = prop.getProperty("db");
        if (TextUtil.isEmpty(db)) {
            this.initDo(prop, 0, 0);
        } else {
            this.initDo(prop, Integer.parseInt(db), 0);
        }
    }

    public RedisClient(Properties prop, int db) {
        this.initDo(prop, db, 0);
    }

    public RedisClient(Properties prop, int db, int maxTotal) {
        this.initDo(prop, db, maxTotal);
    }

    private void initDo(Properties prop, int db, int maxTotal) {
        int socketTimeoutMillis;
        String serializerStr = prop.getProperty("serializer");
        if (!TextUtil.isEmpty(serializerStr)) {
            prop.remove("serializer");
            try {
                Class<?> serializerClz = Class.forName(serializerStr);
                Serializer serializerNew = (Serializer)serializerClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.serializer(serializerNew);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        String server = prop.getProperty("server");
        String user = prop.getProperty("user");
        String password = prop.getProperty("password");
        String maxWaitMillisStr = prop.getProperty("maxWaitMillis");
        String maxTotalStr = prop.getProperty("maxTotal");
        String maxIdleStr = prop.getProperty("maxIdle");
        String minIdleStr = prop.getProperty("minIdle");
        String connectionTimeoutStr = prop.getProperty("connectionTimeout");
        String socketTimeoutMillisStr = prop.getProperty("socketTimeoutMillis");
        String maxAttemptsStr = prop.getProperty("maxAttempts");
        long maxWaitMillis = TextUtil.isEmpty(maxWaitMillisStr) ? 0L : Long.parseLong(maxWaitMillisStr);
        int maxAttempts = TextUtil.isEmpty(maxAttemptsStr) ? 0 : Integer.parseInt(maxAttemptsStr);
        int maxIdle = TextUtil.isEmpty(maxIdleStr) ? 0 : Integer.parseInt(maxIdleStr);
        int minIdle = TextUtil.isEmpty(minIdleStr) ? 0 : Integer.parseInt(minIdleStr);
        int connectionTimeout = TextUtil.isEmpty(connectionTimeoutStr) ? 0 : Integer.parseInt(connectionTimeoutStr);
        int n = socketTimeoutMillis = TextUtil.isEmpty(socketTimeoutMillisStr) ? 0 : Integer.parseInt(socketTimeoutMillisStr);
        if (maxTotal == 0) {
            int n2 = maxTotal = TextUtil.isEmpty(maxTotalStr) ? 0 : Integer.parseInt(maxTotalStr);
        }
        if (db < 0) {
            db = 0;
        }
        if (maxTotal < 200) {
            maxTotal = 200;
        }
        if (maxWaitMillis < 3000L) {
            maxWaitMillis = 3000L;
        }
        if (maxAttempts == 0) {
            maxAttempts = 3;
        }
        if (connectionTimeout == 0) {
            connectionTimeout = 3000;
        }
        ConnectionPoolConfig poolConfig = new ConnectionPoolConfig();
        if (maxTotal > 0) {
            poolConfig.setMaxTotal(maxTotal);
        }
        if (maxIdle > 0) {
            poolConfig.setMaxIdle(maxIdle);
        }
        if (minIdle > 0) {
            poolConfig.setMinIdle(minIdle);
        }
        if (maxWaitMillis > 0L) {
            poolConfig.setMaxWait(Duration.ofMillis(maxWaitMillis));
        }
        poolConfig.setTestOnBorrow(false);
        poolConfig.setTestOnReturn(false);
        DefaultJedisClientConfig.Builder clientConfigBuilder = DefaultJedisClientConfig.builder();
        if (connectionTimeout > 0) {
            clientConfigBuilder.connectionTimeoutMillis(connectionTimeout);
        }
        if (socketTimeoutMillis > 0) {
            clientConfigBuilder.socketTimeoutMillis(socketTimeoutMillis);
        }
        if (!TextUtil.isEmpty(password)) {
            clientConfigBuilder.password(password);
        }
        if (!TextUtil.isEmpty(user)) {
            clientConfigBuilder.user(user);
        }
        clientConfigBuilder.database(db);
        DefaultJedisClientConfig clientConfig = clientConfigBuilder.build();
        if (server.contains(",")) {
            HashSet<HostAndPort> clusterNodes = new HashSet<HostAndPort>();
            for (String fqdn : server.split(",")) {
                if (TextUtil.isEmpty(fqdn)) continue;
                clusterNodes.add(this.parseAddr(fqdn));
            }
            this.unifiedJedis = new JedisCluster(clusterNodes, (JedisClientConfig)clientConfig, maxAttempts, (GenericObjectPoolConfig)poolConfig);
        } else {
            HostAndPort hostAndPort = this.parseAddr(server);
            this.unifiedJedis = new JedisPooled((GenericObjectPoolConfig)poolConfig, hostAndPort, (JedisClientConfig)clientConfig);
        }
    }

    private HostAndPort parseAddr(String addr) {
        if (addr.contains("://")) {
            URI uri = URI.create(addr);
            return new HostAndPort(uri.getHost(), uri.getPort());
        }
        String[] hp = addr.split(":");
        return new HostAndPort(hp[0], Integer.parseInt(hp[1]));
    }

    @Deprecated
    public void open0(Consumer<RedisSession> using) {
        this.open(using);
    }

    @Deprecated
    public <T> T open1(Function<RedisSession, T> using) {
        return this.openAndGet(using);
    }

    public void open(Consumer<RedisSession> using) {
        try (RedisSession session = this.openSession();){
            using.accept(session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T openAndGet(Function<RedisSession, T> using) {
        try (RedisSession session = this.openSession();){
            RedisSession redisSession = using.apply(session);
            return (T)redisSession;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public RedisSession openSession() {
        return new RedisSessionImpl(this.unifiedJedis);
    }

    public RedisAtomic getAtomic(String atomicName) {
        return new RedisAtomic(this, atomicName);
    }

    public RedisAtomic getAtomic(String atomicName, int inSeconds) {
        return new RedisAtomic(this, atomicName, inSeconds);
    }

    public RedisBus getBus() {
        return new RedisBus(this);
    }

    public RedisBucket getBucket() {
        return new RedisBucket(this);
    }

    public RedisHash getHash(String hashName) {
        return new RedisHash(this, hashName);
    }

    public RedisHash getHash(String hashName, int inSeconds) {
        return new RedisHash(this, hashName, inSeconds);
    }

    public RedisLock getLock(String lockName) {
        return new RedisLock(this, lockName);
    }

    public RedisQueue getQueue(String queueName) {
        return new RedisQueue(this, queueName);
    }

    public RedisList getList(String listName) {
        return new RedisList(this, listName);
    }

    public RedisId getId(String idName) {
        return new RedisId(this, idName);
    }

    @Override
    public void close() throws Exception {
        if (this.unifiedJedis != null) {
            this.unifiedJedis.close();
        }
    }
}

