/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx.plus;

import org.noear.redisx.RedisClient;

public class RedisLock {
    private final RedisClient client;
    private final String lockName;

    public RedisLock(RedisClient client, String lockName) {
        this.client = client;
        this.lockName = lockName;
    }

    public String getHolder() {
        return this.client.openAndGet(s -> s.key(this.lockName).get());
    }

    public boolean tryLock(int inSeconds, String holder) {
        return this.client.openAndGet(s -> s.key(this.lockName).expire(inSeconds).lock(holder));
    }

    public boolean tryLock(int inSeconds) {
        return this.tryLock(inSeconds, "_");
    }

    public boolean tryLock() {
        return this.tryLock(3);
    }

    public void unLock(String holder) {
        this.client.open(s -> {
            if (holder == null || holder.equals(s.key(this.lockName).get())) {
                s.key(this.lockName).delete();
            }
        });
    }

    public void unLock() {
        this.unLock(null);
    }

    public boolean isLocked() {
        return this.client.openAndGet(s -> s.key(this.lockName).exists());
    }

    public long ttl() {
        return this.client.openAndGet(s -> s.key(this.lockName).ttl());
    }
}

