/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.service;

import com.rabbitmq.client.Channel;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitChannelFactory;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConfig;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConsumer;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitProducer;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitTransactionListener;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventTran;
import org.noear.solon.cloud.model.EventTranListener;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventServiceRabbitmqImpl
implements CloudEventServicePlus {
    private static final Logger log = LoggerFactory.getLogger(CloudEventServiceRabbitmqImpl.class);
    private final CloudProps cloudProps;
    private RabbitProducer producer;
    private RabbitConsumer consumer;
    private RabbitChannelFactory factory;
    CloudEventObserverManger observerManger = new CloudEventObserverManger();
    private String channel;
    private String group;

    public CloudEventServiceRabbitmqImpl(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        try {
            RabbitConfig config = new RabbitConfig(cloudProps);
            this.factory = new RabbitChannelFactory(config);
            Channel channel = this.factory.createChannel(false);
            this.producer = new RabbitProducer(config, channel);
            this.consumer = new RabbitConsumer(config, channel, this.producer);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void beginTransaction(EventTran transaction) throws CloudEventException {
        if (transaction.getListener(RabbitTransactionListener.class) != null) {
            return;
        }
        try {
            Channel channelTx = this.factory.createChannel(true);
            channelTx.txSelect();
            transaction.setListener((EventTranListener)new RabbitTransactionListener(channelTx));
        }
        catch (Exception e) {
            throw new CloudEventException((Throwable)e);
        }
    }

    public boolean publish(Event event) throws CloudEventException {
        if (Utils.isEmpty((String)event.topic())) {
            throw new IllegalArgumentException("Event missing topic");
        }
        if (Utils.isEmpty((String)event.content())) {
            throw new IllegalArgumentException("Event missing content");
        }
        if (Utils.isEmpty((String)event.key())) {
            event.key(Utils.guid());
        }
        if (event.tran() != null) {
            this.beginTransaction(event.tran());
        }
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + ":" + event.topic();
        try {
            return this.producer.publish(event, topicNew);
        }
        catch (Throwable ex) {
            throw new CloudEventException(ex);
        }
    }

    public void attention(EventLevel level, String channel, String group, String topic, String tag, int qos, CloudEventHandler observer) {
        String topicNew = Utils.isEmpty((String)group) ? topic : group + ":" + topic;
        this.observerManger.add(topicNew, level, group, topic, tag, qos, observer);
    }

    public void subscribe() {
        if (this.observerManger.topicSize() > 0) {
            try {
                this.consumer.init(this.observerManger);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public String getChannel() {
        if (this.channel == null) {
            this.channel = this.cloudProps.getEventChannel();
        }
        return this.channel;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = this.cloudProps.getEventGroup();
        }
        return this.group;
    }
}

