/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.impl;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConfig;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConsumeHandler;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitProducer;
import org.noear.solon.cloud.service.CloudEventObserverManger;

public class RabbitConsumer {
    private RabbitConfig config;
    private Channel channel;
    private RabbitConsumeHandler handler;
    private RabbitProducer producer;

    public RabbitConsumer(RabbitConfig config, Channel channel, RabbitProducer producer) {
        this.config = config;
        this.channel = channel;
        this.producer = producer;
    }

    public void init(CloudEventObserverManger observerManger) throws IOException, TimeoutException {
        this.handler = new RabbitConsumeHandler(this.producer, this.config, this.channel, observerManger);
        this.queueDeclareNormal(observerManger);
        this.queueDeclareReady();
        this.queueDeclareRetry();
    }

    private void queueDeclareNormal(CloudEventObserverManger observerManger) throws IOException {
        HashMap args = new HashMap();
        String string = this.config.queue_normal;
        boolean bl = this.config.durable;
        this.config.getClass();
        this.config.getClass();
        this.channel.queueDeclare(string, bl, false, false, args);
        for (String topic : observerManger.topicAll()) {
            this.channel.queueBind(this.config.queue_normal, this.config.exchangeName, topic, args);
        }
        this.channel.basicConsume(this.config.queue_normal, false, (Consumer)this.handler);
    }

    private void queueDeclareReady() throws IOException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-dead-letter-exchange", this.config.exchangeName);
        args.put("x-dead-letter-routing-key", this.config.queue_retry);
        String string = this.config.queue_ready;
        boolean bl = this.config.durable;
        this.config.getClass();
        this.config.getClass();
        this.channel.queueDeclare(string, bl, false, false, args);
        this.channel.queueBind(this.config.queue_ready, this.config.exchangeName, this.config.queue_ready, args);
    }

    private void queueDeclareRetry() throws IOException {
        HashMap args = new HashMap();
        String string = this.config.queue_retry;
        boolean bl = this.config.durable;
        this.config.getClass();
        this.config.getClass();
        this.channel.queueDeclare(string, bl, false, false, args);
        this.channel.queueBind(this.config.queue_retry, this.config.exchangeName, this.config.queue_retry, args);
        this.channel.basicConsume(this.config.queue_retry, (Consumer)this.handler);
    }
}

