/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConsumeHandler;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventObserver;
import org.noear.solon.cloud.utils.ExpirationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitConsumeTask
implements Runnable {
    static final Logger log = LoggerFactory.getLogger(RabbitConsumeTask.class);
    private String consumerTag;
    private Envelope envelope;
    private AMQP.BasicProperties properties;
    private byte[] body;
    private RabbitConsumeHandler master;

    public RabbitConsumeTask(RabbitConsumeHandler master, String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        this.consumerTag = consumerTag;
        this.envelope = envelope;
        this.properties = properties;
        this.body = body;
        this.master = master;
    }

    @Override
    public void run() {
        try {
            String event_json = new String(this.body);
            Event event = (Event)ONode.deserialize((String)event_json, Event.class);
            event.channel(this.master.eventChannelName);
            boolean isOk = this.onReceive(event);
            if (!isOk) {
                event.times(event.times() + 1);
                try {
                    isOk = this.master.producer.publish(event, this.master.config.queue_ready, ExpirationUtils.getExpiration((int)event.times()));
                }
                catch (Throwable ex) {
                    this.master.getChannel().basicNack(this.envelope.getDeliveryTag(), false, true);
                    isOk = true;
                }
            }
            if (isOk) {
                this.master.getChannel().basicAck(this.envelope.getDeliveryTag(), false);
            }
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap((Throwable)e);
            log.warn(e.getMessage(), e);
        }
    }

    private boolean onReceive(Event event) throws Throwable {
        try {
            return this.onReceiveDo(event);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
            return false;
        }
    }

    private boolean onReceiveDo(Event event) throws Throwable {
        boolean isOk = true;
        EventObserver handler = null;
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + ":" + event.topic();
        handler = this.master.observerManger.getByTopic(topicNew);
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }
}

