package com.baomidou.mybatisplus.solon.integration;

import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.apache.ibatis.solon.MybatisAdapter;
import org.apache.ibatis.solon.MybatisAdapterFactory;

/**
 * 适配器工厂 for mybatis-plus
 *
 * @author noear, iYarnFog
 * @since 1.5
 */
public class MybatisAdapterFactoryPlus implements MybatisAdapterFactory {
    @Override
    public MybatisAdapter create(BeanWrap dsWrap) {
        return new MybatisAdapterPlus(dsWrap);
    }

    @Override
    public MybatisAdapter create(BeanWrap dsWrap, Props dsProps) {
        return new MybatisAdapterPlus(dsWrap, dsProps);
    }
}
