/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.solon.plugins.inner;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.solon.plugins.inner.InnerInterceptor;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChangeRecorderInnerInterceptor
implements InnerInterceptor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String IGNORED_TABLE_COLUMN_PROPERTIES = "ignoredTableColumns";
    private final Map<String, Set<String>> ignoredTableColumns = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> ignoreAllColumns = new HashSet<String>();

    @Override
    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        BoundSql boundSql = mpSh.boundSql();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            OperationResult operationResult;
            long startTs;
            block7: {
                PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
                startTs = System.currentTimeMillis();
                try {
                    Statement statement = CCJSqlParserUtil.parse((String)mpBs.sql());
                    if (statement instanceof Insert) {
                        operationResult = this.processInsert((Insert)statement, mpSh.boundSql());
                        break block7;
                    }
                    if (statement instanceof Update) {
                        operationResult = this.processUpdate((Update)statement, ms, boundSql, connection);
                        break block7;
                    }
                    if (statement instanceof Delete) {
                        operationResult = this.processDelete((Delete)statement, ms, boundSql, connection);
                        break block7;
                    }
                    this.logger.info("other operation sql={}", (Object)mpBs.sql());
                    return;
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error for mappedStatement={}, sql={}", new Object[]{ms.getId(), mpBs.sql(), e});
                    return;
                }
            }
            long costThis = System.currentTimeMillis() - startTs;
            if (operationResult != null) {
                operationResult.setCost(costThis);
                this.dealOperationResult(operationResult);
            }
        }
    }

    protected boolean allowProcess(String sql) {
        String sqlTrim = sql.trim().toUpperCase();
        return sqlTrim.startsWith("INSERT") || sqlTrim.startsWith("UPDATE") || sqlTrim.startsWith("DELETE");
    }

    protected void dealOperationResult(OperationResult operationResult) {
        this.logger.info("{}", (Object)operationResult);
    }

    public OperationResult processInsert(Insert insertStmt, BoundSql boundSql) {
        OperationResult result = new OperationResult();
        result.setOperation("insert");
        result.setTableName(insertStmt.getTable().getName());
        result.setRecordStatus(true);
        result.buildDataStr(this.compareAndGetUpdatedColumnDatas(result.getTableName(), boundSql, (Statement)insertStmt, null));
        return result;
    }

    public OperationResult processUpdate(Update updateStmt, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        Expression where = updateStmt.getWhere();
        Select selectStmt = new Select();
        PlainSelect selectBody = new PlainSelect();
        Table table = updateStmt.getTable();
        Set<String> ignoredColumns = this.ignoredTableColumns.get(table.getName().toUpperCase());
        if (ignoredColumns != null && ignoredColumns.stream().anyMatch("*"::equals)) {
            OperationResult result = new OperationResult();
            result.setOperation("update");
            result.setTableName(table.getName() + ":*");
            result.setRecordStatus(false);
            return result;
        }
        selectBody.setFromItem((FromItem)table);
        ArrayList<Column> updateColumns = new ArrayList<Column>();
        for (UpdateSet updateSet : updateStmt.getUpdateSets()) {
            updateColumns.addAll(updateSet.getColumns());
        }
        Columns2SelectItemsResult buildColumns2SelectItems = this.buildColumns2SelectItems(table.getName(), updateColumns);
        selectBody.setSelectItems(buildColumns2SelectItems.getSelectItems());
        selectBody.setWhere(where);
        selectStmt.setSelectBody((SelectBody)selectBody);
        BoundSql boundSql4Select = new BoundSql(mappedStatement.getConfiguration(), selectStmt.toString(), this.prepareParameterMapping4Select(boundSql.getParameterMappings(), updateStmt), boundSql.getParameterObject());
        MetaObject metaObject = SystemMetaObject.forObject((Object)boundSql);
        Map additionalParameters = (Map)metaObject.getValue("additionalParameters");
        if (additionalParameters != null && !additionalParameters.isEmpty()) {
            for (Map.Entry ety : additionalParameters.entrySet()) {
                boundSql4Select.setAdditionalParameter((String)ety.getKey(), ety.getValue());
            }
        }
        OriginalDataObj originalData = this.buildOriginalObjectData(selectStmt, buildColumns2SelectItems.getPk(), mappedStatement, boundSql4Select, connection);
        OperationResult result = new OperationResult();
        result.setOperation("update");
        result.setTableName(table.getName());
        result.setRecordStatus(true);
        result.buildDataStr(this.compareAndGetUpdatedColumnDatas(result.getTableName(), boundSql, (Statement)updateStmt, originalData));
        return result;
    }

    private List<ParameterMapping> prepareParameterMapping4Select(List<ParameterMapping> originalMappingList, Update updateStmt) {
        ArrayList updateValueExpressions = new ArrayList();
        for (UpdateSet updateSet : updateStmt.getUpdateSets()) {
            updateValueExpressions.addAll(updateSet.getExpressions());
        }
        int removeParamCount = 0;
        for (Expression expression : updateValueExpressions) {
            if (!(expression instanceof JdbcParameter)) continue;
            ++removeParamCount;
        }
        return originalMappingList.subList(removeParamCount, originalMappingList.size());
    }

    private List<DataChangedRecord> compareAndGetUpdatedColumnDatas(String tableName, BoundSql updateSql, Statement statement, OriginalDataObj originalDataObj) {
        HashMap<String, Object> columnNameValMap = new HashMap<String, Object>(updateSql.getParameterMappings().size());
        ArrayList selectItemsFromUpdateSql = new ArrayList();
        if (statement instanceof Update) {
            Update updateStmt = (Update)statement;
            for (UpdateSet updateSet : updateStmt.getUpdateSets()) {
                selectItemsFromUpdateSql.addAll(updateSet.getColumns());
                ArrayList updateList = updateSet.getExpressions();
                for (int i = 0; i < updateList.size(); ++i) {
                    Expression updateExps = (Expression)updateList.get(i);
                    if (updateExps instanceof JdbcParameter) continue;
                    columnNameValMap.put(((Column)updateSet.getColumns().get(i)).getColumnName().toUpperCase(), updateExps.toString());
                }
            }
        } else if (statement instanceof Insert) {
            selectItemsFromUpdateSql.addAll(((Insert)statement).getColumns());
        }
        HashMap<String, String> relatedColumnsUpperCaseWithoutUnderline = new HashMap<String, String>(selectItemsFromUpdateSql.size(), 1.0f);
        for (Object item : selectItemsFromUpdateSql) {
            relatedColumnsUpperCaseWithoutUnderline.put(item.toString().replaceAll("[._\\-$]", "").toUpperCase(), item.toString().toUpperCase());
        }
        MetaObject metaObject = SystemMetaObject.forObject((Object)updateSql.getParameterObject());
        for (ParameterMapping parameterMapping : updateSql.getParameterMappings()) {
            String[] arr;
            String string;
            String propertyName = parameterMapping.getProperty();
            if (propertyName.startsWith("ew.paramNameValuePairs") || !relatedColumnsUpperCaseWithoutUnderline.containsKey(string = (arr = propertyName.split("\\."))[arr.length - 1].replace("_", "").toUpperCase())) continue;
            columnNameValMap.put((String)relatedColumnsUpperCaseWithoutUnderline.get(string), metaObject.getValue(propertyName));
        }
        Set<String> ignoredColumns = this.ignoredTableColumns.get(tableName.toUpperCase());
        if (originalDataObj == null || originalDataObj.isEmpty()) {
            DataChangedRecord oneRecord = new DataChangedRecord();
            ArrayList<DataColumnChangeResult> updateColumns = new ArrayList<DataColumnChangeResult>(columnNameValMap.size());
            for (Map.Entry entry : columnNameValMap.entrySet()) {
                String columnName = (String)entry.getKey();
                if (ignoredColumns != null && ignoredColumns.contains(columnName) || this.ignoreAllColumns.contains(columnName)) continue;
                updateColumns.add(DataColumnChangeResult.constrcutByUpdateVal(columnName, entry.getValue()));
            }
            oneRecord.setUpdatedColumns(updateColumns);
            return Collections.singletonList(oneRecord);
        }
        List<DataChangedRecord> originalDataList = originalDataObj.getOriginalDataObj();
        ArrayList<DataChangedRecord> updateDataList = new ArrayList<DataChangedRecord>(originalDataList.size());
        for (DataChangedRecord dataChangedRecord : originalDataList) {
            if (!dataChangedRecord.hasUpdate(columnNameValMap, ignoredColumns, this.ignoreAllColumns)) continue;
            updateDataList.add(dataChangedRecord);
        }
        return updateDataList;
    }

    private Map<String, Object> buildParameterObjectMap(BoundSql boundSql) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)boundSql.getParameterObject());
        HashMap<String, Object> propertyValMap = new HashMap<String, Object>(boundSql.getParameterMappings().size());
        for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
            String propertyName = parameterMapping.getProperty();
            if (propertyName.startsWith("ew.paramNameValuePairs")) continue;
            Object propertyValue = metaObject.getValue(propertyName);
            propertyValMap.put(propertyName, propertyValue);
        }
        return propertyValMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String buildOriginalData(Select selectStmt, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement(selectStmt.toString());){
            DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), boundSql);
            parameterHandler.setParameters(statement);
            ResultSet resultSet = statement.executeQuery();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            StringBuilder sb = new StringBuilder("[");
            while (true) {
                if (resultSet.next()) {
                    sb.append("{");
                } else {
                    sb.append("]");
                    resultSet.close();
                    String string = sb.toString();
                    return string;
                }
                for (int i = 1; i <= columnCount; ++i) {
                    sb.append("\"").append(metaData.getColumnName(i)).append("\":\"");
                    Object res = resultSet.getObject(i);
                    if (res instanceof Clob) {
                        sb.append(DataColumnChangeResult.convertClob((Clob)res));
                    } else {
                        sb.append(res);
                    }
                    sb.append("\",");
                }
                sb.replace(sb.length() - 1, sb.length(), "}");
            }
        }
        catch (Exception e) {
            this.logger.error("try to get record tobe deleted for selectStmt={}", (Object)selectStmt, (Object)e);
            return "failed to get original data";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OriginalDataObj buildOriginalObjectData(Select selectStmt, Column pk, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement(selectStmt.toString());){
            DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), boundSql);
            parameterHandler.setParameters(statement);
            ResultSet resultSet = statement.executeQuery();
            LinkedList<DataChangedRecord> originalObjectDatas = new LinkedList<DataChangedRecord>();
            while (resultSet.next()) {
                originalObjectDatas.add(this.prepareOriginalDataObj(resultSet, pk));
            }
            OriginalDataObj result = new OriginalDataObj();
            result.setOriginalDataObj(originalObjectDatas);
            resultSet.close();
            OriginalDataObj originalDataObj = result;
            return originalDataObj;
        }
        catch (Exception e) {
            this.logger.error("try to get record tobe updated for selectStmt={}", (Object)selectStmt, (Object)e);
            return new OriginalDataObj();
        }
    }

    private DataChangedRecord prepareOriginalDataObj(ResultSet resultSet, Column pk) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        LinkedList<DataColumnChangeResult> originalColumnDatas = new LinkedList<DataColumnChangeResult>();
        DataColumnChangeResult pkval = null;
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = metaData.getColumnName(i).toUpperCase();
            DataColumnChangeResult col = DataColumnChangeResult.constrcutByOriginalVal(columnName, resultSet.getObject(i));
            if (pk != null && columnName.equalsIgnoreCase(pk.getColumnName())) {
                pkval = col;
                continue;
            }
            originalColumnDatas.add(col);
        }
        DataChangedRecord changedRecord = new DataChangedRecord();
        changedRecord.setOriginalColumnDatas(originalColumnDatas);
        if (pkval != null) {
            changedRecord.setPkColumnName(pkval.getColumnName());
            changedRecord.setPkColumnVal(pkval.getOriginalValue());
        }
        return changedRecord;
    }

    private Columns2SelectItemsResult buildColumns2SelectItems(String tableName, List<Column> columns) {
        if (columns == null || columns.isEmpty()) {
            return Columns2SelectItemsResult.build(Collections.singletonList(new AllColumns()), 0);
        }
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>(columns.size());
        for (Column column : columns) {
            selectItems.add((SelectItem)new SelectExpressionItem((Expression)column));
        }
        for (TableInfo tableInfo : TableInfoHelper.getTableInfos()) {
            if (!tableName.equalsIgnoreCase(tableInfo.getTableName())) continue;
            Column pk = new Column(tableInfo.getKeyColumn());
            selectItems.add((SelectItem)new SelectExpressionItem((Expression)pk));
            Columns2SelectItemsResult result = Columns2SelectItemsResult.build(selectItems, 1);
            result.setPk(pk);
            return result;
        }
        return Columns2SelectItemsResult.build(selectItems, 0);
    }

    private String buildParameterObject(BoundSql boundSql) {
        Object paramObj = boundSql.getParameterObject();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (paramObj instanceof Map) {
            String key;
            Map paramMap = (Map)paramObj;
            int index = 1;
            boolean hasParamIndex = false;
            while (paramMap.containsKey(key = "param" + index)) {
                Object paramIndex = paramMap.get(key);
                sb.append("\"").append(key).append("\"").append(":").append("\"").append(paramIndex).append("\"").append(",");
                hasParamIndex = true;
                ++index;
            }
            if (hasParamIndex) {
                sb.delete(sb.length() - 1, sb.length());
                sb.append("}");
                return sb.toString();
            }
            for (Map.Entry ety : paramMap.entrySet()) {
                sb.append("\"").append((String)ety.getKey()).append("\"").append(":").append("\"").append(ety.getValue()).append("\"").append(",");
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append("}");
            return sb.toString();
        }
        sb.append("param:").append(paramObj);
        sb.append("}");
        return sb.toString();
    }

    public OperationResult processDelete(Delete deleteStmt, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        Table table = deleteStmt.getTable();
        Expression where = deleteStmt.getWhere();
        Select selectStmt = new Select();
        PlainSelect selectBody = new PlainSelect();
        selectBody.setFromItem((FromItem)table);
        selectBody.setSelectItems(Collections.singletonList(new AllColumns()));
        selectBody.setWhere(where);
        selectStmt.setSelectBody((SelectBody)selectBody);
        String originalData = this.buildOriginalData(selectStmt, mappedStatement, boundSql, connection);
        OperationResult result = new OperationResult();
        result.setOperation("delete");
        result.setTableName(table.getName());
        result.setRecordStatus(originalData.startsWith("["));
        result.setChangedData(originalData);
        return result;
    }

    @Override
    public void setProperties(Properties properties) {
        String[] array;
        String ignoredTableColumns = properties.getProperty(IGNORED_TABLE_COLUMN_PROPERTIES);
        if (ignoredTableColumns == null || ignoredTableColumns.trim().isEmpty()) {
            return;
        }
        for (String table : array = ignoredTableColumns.split(";")) {
            int index = table.indexOf(".");
            if (index == -1) {
                this.logger.warn("invalid data={} for ignoredColumns, format should be TABLE_NAME1.COLUMN1,COLUMN2; TABLE2.COLUMN1,COLUMN2;", (Object)table);
                continue;
            }
            String tableName = table.substring(0, index).trim().toUpperCase();
            String[] columnArray = table.substring(index + 1).split(",");
            HashSet<String> columnSet = new HashSet<String>(columnArray.length);
            for (String column : columnArray) {
                if ((column = column.trim().toUpperCase()).isEmpty()) continue;
                columnSet.add(column);
            }
            if ("*".equals(tableName)) {
                this.ignoreAllColumns.addAll(columnSet);
                continue;
            }
            this.ignoredTableColumns.put(tableName, columnSet);
        }
    }

    public static class DataChangedRecord {
        private String pkColumnName;
        private Object pkColumnVal;
        private List<DataColumnChangeResult> originalColumnDatas;
        private List<DataColumnChangeResult> updatedColumns;

        public boolean hasUpdate(Map<String, Object> columnNameValMap, Set<String> ignoredColumns, Set<String> ignoreAllColumns) {
            if (this.originalColumnDatas == null) {
                return true;
            }
            boolean hasUpdate = false;
            this.updatedColumns = new ArrayList<DataColumnChangeResult>(this.originalColumnDatas.size());
            for (DataColumnChangeResult originalColumn : this.originalColumnDatas) {
                Object updatedValue;
                String columnName = originalColumn.getColumnName().toUpperCase();
                if (ignoredColumns != null && ignoredColumns.contains(columnName) || ignoreAllColumns.contains(columnName) || !originalColumn.isDataChanged(updatedValue = columnNameValMap.get(columnName))) continue;
                hasUpdate = true;
                originalColumn.setUpdateValue(updatedValue);
                this.updatedColumns.add(originalColumn);
            }
            return hasUpdate;
        }

        public String generateUpdatedDataStr() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (this.pkColumnName != null) {
                sb.append("\"").append(this.pkColumnName).append("\"").append(":").append("\"").append(this.convertDoubleQuotes(this.pkColumnVal)).append("\"").append(",");
            }
            for (DataColumnChangeResult update : this.updatedColumns) {
                sb.append(update.generateDataStr());
            }
            sb.replace(sb.length() - 1, sb.length(), "}");
            return sb.toString();
        }

        public String convertDoubleQuotes(Object obj) {
            if (obj == null) {
                return null;
            }
            return obj.toString().replace("\"", "\\\"");
        }

        @Generated
        public DataChangedRecord() {
        }

        @Generated
        public String getPkColumnName() {
            return this.pkColumnName;
        }

        @Generated
        public Object getPkColumnVal() {
            return this.pkColumnVal;
        }

        @Generated
        public List<DataColumnChangeResult> getOriginalColumnDatas() {
            return this.originalColumnDatas;
        }

        @Generated
        public List<DataColumnChangeResult> getUpdatedColumns() {
            return this.updatedColumns;
        }

        @Generated
        public void setPkColumnName(String pkColumnName) {
            this.pkColumnName = pkColumnName;
        }

        @Generated
        public void setPkColumnVal(Object pkColumnVal) {
            this.pkColumnVal = pkColumnVal;
        }

        @Generated
        public void setOriginalColumnDatas(List<DataColumnChangeResult> originalColumnDatas) {
            this.originalColumnDatas = originalColumnDatas;
        }

        @Generated
        public void setUpdatedColumns(List<DataColumnChangeResult> updatedColumns) {
            this.updatedColumns = updatedColumns;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataChangedRecord)) {
                return false;
            }
            DataChangedRecord other = (DataChangedRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$pkColumnName = this.getPkColumnName();
            String other$pkColumnName = other.getPkColumnName();
            if (this$pkColumnName == null ? other$pkColumnName != null : !this$pkColumnName.equals(other$pkColumnName)) {
                return false;
            }
            Object this$pkColumnVal = this.getPkColumnVal();
            Object other$pkColumnVal = other.getPkColumnVal();
            if (this$pkColumnVal == null ? other$pkColumnVal != null : !this$pkColumnVal.equals(other$pkColumnVal)) {
                return false;
            }
            List<DataColumnChangeResult> this$originalColumnDatas = this.getOriginalColumnDatas();
            List<DataColumnChangeResult> other$originalColumnDatas = other.getOriginalColumnDatas();
            if (this$originalColumnDatas == null ? other$originalColumnDatas != null : !((Object)this$originalColumnDatas).equals(other$originalColumnDatas)) {
                return false;
            }
            List<DataColumnChangeResult> this$updatedColumns = this.getUpdatedColumns();
            List<DataColumnChangeResult> other$updatedColumns = other.getUpdatedColumns();
            return !(this$updatedColumns == null ? other$updatedColumns != null : !((Object)this$updatedColumns).equals(other$updatedColumns));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DataChangedRecord;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $pkColumnName = this.getPkColumnName();
            result = result * 59 + ($pkColumnName == null ? 43 : $pkColumnName.hashCode());
            Object $pkColumnVal = this.getPkColumnVal();
            result = result * 59 + ($pkColumnVal == null ? 43 : $pkColumnVal.hashCode());
            List<DataColumnChangeResult> $originalColumnDatas = this.getOriginalColumnDatas();
            result = result * 59 + ($originalColumnDatas == null ? 43 : ((Object)$originalColumnDatas).hashCode());
            List<DataColumnChangeResult> $updatedColumns = this.getUpdatedColumns();
            result = result * 59 + ($updatedColumns == null ? 43 : ((Object)$updatedColumns).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DataChangeRecorderInnerInterceptor.DataChangedRecord(pkColumnName=" + this.getPkColumnName() + ", pkColumnVal=" + this.getPkColumnVal() + ", originalColumnDatas=" + this.getOriginalColumnDatas() + ", updatedColumns=" + this.getUpdatedColumns() + ")";
        }
    }

    public static class DataColumnChangeResult {
        private String columnName;
        private Object originalValue;
        private Object updateValue;

        public boolean isDataChanged(Object updateValue) {
            if (!Objects.equals(this.originalValue, updateValue)) {
                if (updateValue instanceof Number && this.originalValue instanceof Number) {
                    BigDecimal original;
                    BigDecimal update = new BigDecimal(updateValue.toString());
                    return update.compareTo(original = new BigDecimal(this.originalValue.toString())) != 0;
                }
                if (updateValue instanceof Date && this.originalValue instanceof Date) {
                    Date update = (Date)updateValue;
                    Date original = (Date)this.originalValue;
                    return update.compareTo(original) != 0;
                }
                if (this.originalValue instanceof Clob) {
                    String originalStr = DataColumnChangeResult.convertClob((Clob)this.originalValue);
                    this.setOriginalValue(originalStr);
                    return !originalStr.equals(updateValue);
                }
                return true;
            }
            if (this.originalValue instanceof Comparable) {
                Comparable original = (Comparable)this.originalValue;
                Comparable update = (Comparable)updateValue;
                return original.compareTo(update) != 0;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static String convertClob(Clob clobObj) {
            try {
                return clobObj.getSubString(0L, (int)clobObj.length());
            }
            catch (Exception e) {
                try (Reader is = clobObj.getCharacterStream();){
                    int readChars;
                    char[] chars = new char[64];
                    StringBuilder sb = new StringBuilder();
                    while ((readChars = is.read(chars)) != -1) {
                        sb.append(chars, 0, readChars);
                    }
                    String string = sb.toString();
                    return string;
                }
                catch (Exception e2) {
                    return "unknown clobObj";
                }
            }
        }

        public static DataColumnChangeResult constrcutByUpdateVal(String columnName, Object updateValue) {
            DataColumnChangeResult res = new DataColumnChangeResult();
            res.setColumnName(columnName);
            res.setUpdateValue(updateValue);
            return res;
        }

        public static DataColumnChangeResult constrcutByOriginalVal(String columnName, Object originalValue) {
            DataColumnChangeResult res = new DataColumnChangeResult();
            res.setColumnName(columnName);
            res.setOriginalValue(originalValue);
            return res;
        }

        public String generateDataStr() {
            StringBuilder sb = new StringBuilder();
            sb.append("\"").append(this.columnName).append("\"").append(":").append("\"").append(this.convertDoubleQuotes(this.originalValue)).append("->").append(this.convertDoubleQuotes(this.updateValue)).append("\"").append(",");
            return sb.toString();
        }

        public String convertDoubleQuotes(Object obj) {
            if (obj == null) {
                return null;
            }
            return obj.toString().replace("\"", "\\\"");
        }

        @Generated
        public DataColumnChangeResult() {
        }

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        public Object getOriginalValue() {
            return this.originalValue;
        }

        @Generated
        public Object getUpdateValue() {
            return this.updateValue;
        }

        @Generated
        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Generated
        public void setOriginalValue(Object originalValue) {
            this.originalValue = originalValue;
        }

        @Generated
        public void setUpdateValue(Object updateValue) {
            this.updateValue = updateValue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataColumnChangeResult)) {
                return false;
            }
            DataColumnChangeResult other = (DataColumnChangeResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            Object this$originalValue = this.getOriginalValue();
            Object other$originalValue = other.getOriginalValue();
            if (this$originalValue == null ? other$originalValue != null : !this$originalValue.equals(other$originalValue)) {
                return false;
            }
            Object this$updateValue = this.getUpdateValue();
            Object other$updateValue = other.getUpdateValue();
            return !(this$updateValue == null ? other$updateValue != null : !this$updateValue.equals(other$updateValue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DataColumnChangeResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            Object $originalValue = this.getOriginalValue();
            result = result * 59 + ($originalValue == null ? 43 : $originalValue.hashCode());
            Object $updateValue = this.getUpdateValue();
            result = result * 59 + ($updateValue == null ? 43 : $updateValue.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DataChangeRecorderInnerInterceptor.DataColumnChangeResult(columnName=" + this.getColumnName() + ", originalValue=" + this.getOriginalValue() + ", updateValue=" + this.getUpdateValue() + ")";
        }
    }

    public static class OriginalDataObj {
        private List<DataChangedRecord> originalDataObj;

        public boolean isEmpty() {
            return this.originalDataObj == null || this.originalDataObj.isEmpty();
        }

        @Generated
        public OriginalDataObj() {
        }

        @Generated
        public List<DataChangedRecord> getOriginalDataObj() {
            return this.originalDataObj;
        }

        @Generated
        public void setOriginalDataObj(List<DataChangedRecord> originalDataObj) {
            this.originalDataObj = originalDataObj;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OriginalDataObj)) {
                return false;
            }
            OriginalDataObj other = (OriginalDataObj)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<DataChangedRecord> this$originalDataObj = this.getOriginalDataObj();
            List<DataChangedRecord> other$originalDataObj = other.getOriginalDataObj();
            return !(this$originalDataObj == null ? other$originalDataObj != null : !((Object)this$originalDataObj).equals(other$originalDataObj));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OriginalDataObj;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<DataChangedRecord> $originalDataObj = this.getOriginalDataObj();
            result = result * 59 + ($originalDataObj == null ? 43 : ((Object)$originalDataObj).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DataChangeRecorderInnerInterceptor.OriginalDataObj(originalDataObj=" + this.getOriginalDataObj() + ")";
        }
    }

    public static class Columns2SelectItemsResult {
        private Column pk;
        private List<SelectItem> selectItems;
        private int additionalItemCount;

        public static Columns2SelectItemsResult build(List<SelectItem> selectItems, int additionalItemCount) {
            Columns2SelectItemsResult result = new Columns2SelectItemsResult();
            result.setSelectItems(selectItems);
            result.setAdditionalItemCount(additionalItemCount);
            return result;
        }

        @Generated
        public Columns2SelectItemsResult() {
        }

        @Generated
        public Column getPk() {
            return this.pk;
        }

        @Generated
        public List<SelectItem> getSelectItems() {
            return this.selectItems;
        }

        @Generated
        public int getAdditionalItemCount() {
            return this.additionalItemCount;
        }

        @Generated
        public void setPk(Column pk) {
            this.pk = pk;
        }

        @Generated
        public void setSelectItems(List<SelectItem> selectItems) {
            this.selectItems = selectItems;
        }

        @Generated
        public void setAdditionalItemCount(int additionalItemCount) {
            this.additionalItemCount = additionalItemCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Columns2SelectItemsResult)) {
                return false;
            }
            Columns2SelectItemsResult other = (Columns2SelectItemsResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAdditionalItemCount() != other.getAdditionalItemCount()) {
                return false;
            }
            Column this$pk = this.getPk();
            Column other$pk = other.getPk();
            if (this$pk == null ? other$pk != null : !this$pk.equals(other$pk)) {
                return false;
            }
            List<SelectItem> this$selectItems = this.getSelectItems();
            List<SelectItem> other$selectItems = other.getSelectItems();
            return !(this$selectItems == null ? other$selectItems != null : !((Object)this$selectItems).equals(other$selectItems));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Columns2SelectItemsResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAdditionalItemCount();
            Column $pk = this.getPk();
            result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
            List<SelectItem> $selectItems = this.getSelectItems();
            result = result * 59 + ($selectItems == null ? 43 : ((Object)$selectItems).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DataChangeRecorderInnerInterceptor.Columns2SelectItemsResult(pk=" + this.getPk() + ", selectItems=" + this.getSelectItems() + ", additionalItemCount=" + this.getAdditionalItemCount() + ")";
        }
    }

    public static class OperationResult {
        private String operation;
        private boolean recordStatus;
        private String tableName;
        private String changedData;
        private long cost;

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public boolean isRecordStatus() {
            return this.recordStatus;
        }

        public void setRecordStatus(boolean recordStatus) {
            this.recordStatus = recordStatus;
        }

        public void buildDataStr(List<DataChangedRecord> records) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (DataChangedRecord r : records) {
                sb.append(r.generateUpdatedDataStr()).append(",");
            }
            if (sb.length() == 1) {
                sb.append("]");
                this.changedData = sb.toString();
                return;
            }
            sb.replace(sb.length() - 1, sb.length(), "]");
            this.changedData = sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("\"").append("tableName").append("\"").append(":").append("\"").append(this.tableName).append("\"").append(",");
            sb.append("\"").append("operation").append("\"").append(":").append("\"").append(this.operation).append("\"").append(",");
            sb.append("\"").append("recordStatus").append("\"").append(":").append("\"").append(this.recordStatus).append("\"").append(",");
            sb.append("\"").append("changedData").append("\"").append(":").append(this.changedData).append(",");
            sb.append("\"").append("cost(ms)").append("\"").append(":").append(this.cost);
            sb.append("}");
            return sb.toString();
        }

        @Generated
        public OperationResult() {
        }

        @Generated
        public String getChangedData() {
            return this.changedData;
        }

        @Generated
        public long getCost() {
            return this.cost;
        }

        @Generated
        public void setChangedData(String changedData) {
            this.changedData = changedData;
        }

        @Generated
        public void setCost(long cost) {
            this.cost = cost;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperationResult)) {
                return false;
            }
            OperationResult other = (OperationResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRecordStatus() != other.isRecordStatus()) {
                return false;
            }
            if (this.getCost() != other.getCost()) {
                return false;
            }
            String this$operation = this.getOperation();
            String other$operation = other.getOperation();
            if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            String this$changedData = this.getChangedData();
            String other$changedData = other.getChangedData();
            return !(this$changedData == null ? other$changedData != null : !this$changedData.equals(other$changedData));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OperationResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRecordStatus() ? 79 : 97);
            long $cost = this.getCost();
            result = result * 59 + (int)($cost >>> 32 ^ $cost);
            String $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            String $changedData = this.getChangedData();
            result = result * 59 + ($changedData == null ? 43 : $changedData.hashCode());
            return result;
        }
    }
}

