/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.solon.handlers;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.solon.handlers.AbstractJsonTypeHandler;
import com.google.gson.Gson;
import lombok.Generated;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedTypes(value={Object.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR})
public class GsonTypeHandler
extends AbstractJsonTypeHandler<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GsonTypeHandler.class);
    private static Gson GSON;
    private final Class<?> type;

    public GsonTypeHandler(Class<?> type) {
        if (log.isTraceEnabled()) {
            log.trace("GsonTypeHandler(" + type + ")");
        }
        Assert.notNull(type, (String)"Type argument cannot be null", (Object[])new Object[0]);
        this.type = type;
    }

    @Override
    protected Object parse(String json) {
        return GsonTypeHandler.getGson().fromJson(json, this.type);
    }

    @Override
    protected String toJson(Object obj) {
        return GsonTypeHandler.getGson().toJson(obj);
    }

    public static Gson getGson() {
        if (null == GSON) {
            GSON = new Gson();
        }
        return GSON;
    }

    public static void setGson(Gson gson) {
        Assert.notNull((Object)gson, (String)"Gson should not be null", (Object[])new Object[0]);
        GSON = gson;
    }
}

