/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.mqtt.service;

import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.extend.mqtt.service.MqttClientManager;
import org.noear.solon.cloud.extend.mqtt.service.MqttMessageHandler;
import org.noear.solon.core.util.RunUtil;

public class MqttMessageListenerImpl
implements IMqttMessageListener {
    private CloudEventHandler eventHandler;
    private String eventChannelName;
    private MqttClientManager clientManager;

    public MqttMessageListenerImpl(MqttClientManager clientManager, String eventChannelName, CloudEventHandler eventHandler) {
        this.eventHandler = eventHandler;
        this.eventChannelName = eventChannelName;
        this.clientManager = clientManager;
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        MqttMessageHandler handler = new MqttMessageHandler(this.clientManager, this.eventChannelName, this.eventHandler, topic, message);
        if (this.clientManager.getAsync()) {
            RunUtil.parallel((Runnable)handler);
        } else {
            handler.run();
        }
    }
}

